/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.XPathParts;

public class CharacterFallbacks {
    private static CharacterFallbacks SINGLETON = new CharacterFallbacks();
    private HashMap<Integer, List<String>> data = new HashMap();

    public static CharacterFallbacks make() {
        return SINGLETON;
    }

    public List<String> getSubstitutes(int cp) {
        return this.data.get(cp);
    }

    private CharacterFallbacks() {
        Factory cldrFactory = Factory.make(CLDRPaths.DEFAULT_SUPPLEMENTAL_DIRECTORY, ".*");
        CLDRFile characterFallbacks = cldrFactory.make("characters", false);
        Comparator<String> comp = DtdData.getInstance(DtdType.supplementalData).getDtdComparator(null);
        Iterator<String> it = characterFallbacks.iterator("//supplementalData/characters/", comp);
        while (it.hasNext()) {
            String path = it.next();
            String fullPath = characterFallbacks.getFullXPath(path);
            XPathParts parts = XPathParts.getFrozenInstance(fullPath);
            String value = parts.getAttributeValue(-2, "value");
            if (value.codePointCount(0, value.length()) != 1) {
                throw new IllegalArgumentException("Illegal value in " + fullPath);
            }
            int cp = value.codePointAt(0);
            String substitute = characterFallbacks.getStringValue(path);
            List<String> substitutes = this.data.get(cp);
            if (substitutes == null) {
                substitutes = new ArrayList<String>();
                this.data.put(cp, substitutes);
            }
            substitutes.add(substitute);
        }
        CldrUtility.protectCollection(this.data);
    }
}

