/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Splitter;
import com.ibm.icu.impl.Row;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ChainedMap;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DayPeriodData;
import org.unicode.cldr.util.DayPeriodInfo;
import org.unicode.cldr.util.DayPeriods;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageGroup;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class DayPeriodConverter {
    private static final boolean TO_CODE = true;
    static final Map<ULocale, DayInfo> DATA = new LinkedHashMap<ULocale, DayInfo>();
    static final ULocale ROOT2;

    public static void main(String[] args) {
        DayPeriodConverter.generateFieldNames();
    }

    private static void generateFieldNames() {
        SupplementalDataInfo sdi = CLDRConfig.getInstance().getSupplementalDataInfo();
        Factory factory = CLDRConfig.getInstance().getFullCldrFactory();
        EnumSet<DayPeriodInfo.DayPeriod> dayPeriodSet = EnumSet.noneOf(DayPeriodInfo.DayPeriod.class);
        String prefix = DayPeriodConverter.getPrefix("stand-alone");
        for (String locale : sdi.getDayPeriodLocales(DayPeriodInfo.Type.format)) {
            ULocale uLocale = new ULocale(locale);
            DayPeriodInfo dayPeriodInfo = sdi.getDayPeriods(DayPeriodInfo.Type.format, locale);
            System.out.println("# " + locale);
            dayPeriodSet.clear();
            dayPeriodSet.addAll(dayPeriodInfo.getPeriods());
            boolean fieldType = false;
            CLDRFile cldrFile = factory.make(locale, false);
            for (String path : cldrFile) {
                if (path.endsWith("/alias") || !path.startsWith(prefix)) continue;
                XPathParts parts = XPathParts.getFrozenInstance(path);
                String width = parts.getAttributeValue(-2, "type");
                DayPeriodInfo.DayPeriod period = DayPeriodInfo.DayPeriod.fromString(parts.getAttributeValue(-1, "type"));
                String draft = parts.getAttributeValue(-1, "draft");
                System.out.println("#old: \u00ab" + cldrFile.getStringValue(path) + "\u00bb, width: " + width + ", period: " + String.valueOf((Object)period) + (String)(draft == null ? "" : ", draft: " + draft));
                System.out.println("locale=" + locale + " ; action=delete ; path=" + path);
            }
            DayPeriodConverter.addOldDayPeriod(cldrFile, DayPeriodInfo.DayPeriod.am);
            DayPeriodConverter.addOldDayPeriod(cldrFile, DayPeriodInfo.DayPeriod.pm);
            for (DayPeriodInfo.DayPeriod dayPeriod : dayPeriodSet) {
                String name = DayPeriodConverter.getNativeName(uLocale, dayPeriod);
                if (name == null) continue;
                DayPeriodConverter.showModLine(locale, dayPeriod, name, false);
            }
            System.out.println();
        }
    }

    private static void showModLine(String locale, DayPeriodInfo.DayPeriod dayPeriod, String name, boolean draft) {
        Object path = DayPeriodConverter.getPath("stand-alone", "wide", dayPeriod);
        if (draft) {
            path = (String)path + "[@draft=\"provisional\"]";
        }
        System.out.println("locale=" + locale + " ; action=add ; new_value=" + name + " ; new_path=" + (String)path);
    }

    private static void addOldDayPeriod(CLDRFile cldrFile, DayPeriodInfo.DayPeriod period) {
        String amString = cldrFile.getStringValue(DayPeriodConverter.getPath("format", "wide", period));
        if (amString != null) {
            String locale;
            DayPeriodConverter.showModLine(locale, period, amString, !(locale = cldrFile.getLocaleID()).equals("root") && !locale.equals("en"));
        }
    }

    static String getPath(String context, String width, DayPeriodInfo.DayPeriod dayPeriod) {
        return DayPeriodConverter.getPrefix(context) + "/dayPeriodWidth[@type=\"" + width + "\"]/dayPeriod[@type=\"" + String.valueOf((Object)dayPeriod) + "\"]";
    }

    private static String getPrefix(String context) {
        return "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dayPeriods/dayPeriodContext[@type=\"" + context + "\"]";
    }

    static void generateFormat() {
        SupplementalDataInfo sdi = CLDRConfig.getInstance().getSupplementalDataInfo();
        ChainedMap.M3 allData = ChainedMap.of(new TreeMap(LanguageGroup.COMPARATOR), new TreeMap(), DayPeriodInfo.DayPeriod.class);
        for (String string : sdi.getDayPeriodLocales(DayPeriodInfo.Type.selection)) {
            ULocale ulocale = new ULocale(string);
            NoonMidnight nm = NoonMidnight.get(string);
            boolean hasNoon = nm != null && nm.noon != null;
            boolean hasMidnight = nm != null && nm.midnight != null;
            DayPeriodInfo data = sdi.getDayPeriods(DayPeriodInfo.Type.selection, string);
            if (hasMidnight) {
                allData.put(ulocale, 0, DayPeriodInfo.DayPeriod.midnight);
            }
            if (hasNoon) {
                allData.put(ulocale, 43200000, DayPeriodInfo.DayPeriod.noon);
            }
            int lastTime = -1;
            DayPeriodInfo.DayPeriod lastPeriod = null;
            for (int index = 0; index < data.getPeriodCount(); ++index) {
                Row.R3<Integer, Boolean, DayPeriodInfo.DayPeriod> row = data.getPeriod(index);
                DayPeriodInfo.DayPeriod period = (DayPeriodInfo.DayPeriod)((Object)row.get2());
                int time = (Integer)row.get0();
                if (!((Boolean)row.get1()).booleanValue()) {
                    ++time;
                } else if (hasMidnight && time == 0) {
                    ++time;
                } else if (hasNoon) {
                    if (time == 43200000) {
                        ++time;
                    } else if (lastTime < 43200000 && time > 43200000) {
                        System.out.println(string + ": Splitting " + lastTime + ", " + String.valueOf((Object)lastPeriod) + ", " + time + ", " + String.valueOf((Object)period));
                        allData.put(ulocale, 43200001, lastPeriod);
                    }
                }
                allData.put(ulocale, time, period);
                lastTime = time;
                lastPeriod = period;
            }
        }
        for (Map.Entry entry : allData) {
            ULocale locale = (ULocale)entry.getKey();
            System.out.println("\t\t<dayPeriodRules locales=\"" + String.valueOf(locale) + "\">");
            ArrayList list = new ArrayList(((Map)entry.getValue()).entrySet());
            for (int i = 0; i < list.size(); ++i) {
                Map.Entry item = list.get(i);
                DayPeriodInfo.DayPeriod dayPeriod = (DayPeriodInfo.DayPeriod)((Object)item.getValue());
                int start = (Integer)item.getKey();
                int end = i + 1 == list.size() ? 86400000 : (Integer)list.get(i + 1).getKey();
                String startType = "from";
                if ((start & 1) != 0) {
                    startType = "after";
                }
                System.out.println("\t\t\t<dayPeriodRule type=\"" + dayPeriod.toString().toLowerCase(Locale.ENGLISH) + "\" " + ((start /= 3600000) == (end /= 3600000) ? "at=\"" + start : startType + "=\"" + start + ":00\" before=\"" + end) + ":00\"/> <!-- " + DayPeriodConverter.getNativeName(locale, dayPeriod) + " -->");
            }
            System.out.println("\t\t</dayPeriodRules>");
        }
    }

    void oldMain() {
    }

    private static String getNativeName(ULocale locale, DayPeriodInfo.DayPeriod dayPeriod) {
        DayInfo data;
        NoonMidnight nm = NoonMidnight.get(locale.toString());
        if (nm == null) {
            return null;
        }
        if (dayPeriod == DayPeriodInfo.DayPeriod.noon) {
            return (String)((Object)CldrUtility.ifNull(nm.noon, "missing-" + String.valueOf((Object)dayPeriod)));
        }
        if (dayPeriod == DayPeriodInfo.DayPeriod.midnight) {
            return (String)((Object)CldrUtility.ifNull(nm.midnight, "missing-" + String.valueOf((Object)dayPeriod)));
        }
        if (locale.equals(ROOT2)) {
            if (dayPeriod == DayPeriodInfo.DayPeriod.morning1) {
                return "am";
            }
            if (dayPeriod == DayPeriodInfo.DayPeriod.afternoon1) {
                return "pm";
            }
        }
        if ((data = DATA.get(locale)) == null) {
            return "missing-" + String.valueOf((Object)dayPeriod);
        }
        DayPeriods.DayPeriod otherDayPeriod = DayPeriods.DayPeriod.valueOf(dayPeriod.toString().toUpperCase(Locale.ENGLISH));
        return data.toNativeName.get((Object)otherDayPeriod);
    }

    static void writeOld() {
        System.out.println("\t<dayPeriodRuleSet type=\"selection\">");
        for (Map.Entry<ULocale, DayInfo> foo : DATA.entrySet()) {
            DayPeriodConverter.check(foo.getKey(), foo.getValue());
            System.out.println(foo.getValue().toCldr());
        }
        System.out.println("\t</dayPeriodRuleSet>");
    }

    private static void check(ULocale locale, DayInfo value) {
        DayPeriodConverter.check(locale, DayPeriods.DayPeriod.MORNING1, DayPeriods.DayPeriod.MORNING2, value);
        DayPeriodConverter.check(locale, DayPeriods.DayPeriod.AFTERNOON1, DayPeriods.DayPeriod.AFTERNOON2, value);
        DayPeriodConverter.check(locale, DayPeriods.DayPeriod.EVENING1, DayPeriods.DayPeriod.EVENING2, value);
        DayPeriodConverter.check(locale, DayPeriods.DayPeriod.NIGHT1, DayPeriods.DayPeriod.NIGHT2, value);
        DayPeriods.DayPeriod lastDp = value.data[23];
        for (DayPeriods.DayPeriod dp : value.data) {
            if (lastDp.compareTo(dp) > 0 && (lastDp != DayPeriods.DayPeriod.NIGHT1 && lastDp != DayPeriods.DayPeriod.NIGHT2 || dp != DayPeriods.DayPeriod.MORNING1)) {
                throw new IllegalArgumentException(String.valueOf(locale) + " " + String.valueOf((Object)lastDp) + " > " + String.valueOf((Object)dp));
            }
            lastDp = dp;
        }
    }

    private static void check(ULocale locale, DayPeriods.DayPeriod morning1, DayPeriods.DayPeriod morning2, DayInfo value) {
        if (value.toNativeName.containsKey((Object)morning2) && !value.toNativeName.containsKey((Object)morning1)) {
            throw new IllegalArgumentException(String.valueOf(locale) + " Contains " + String.valueOf((Object)morning2) + ", but not " + String.valueOf((Object)morning1));
        }
    }

    static {
        for (String[] x : DayPeriodData.RAW_DATA) {
            ULocale locale = new ULocale(x[0]);
            int start = Integer.parseInt(x[1]);
            DayPeriods.DayPeriod dayPeriod = DayPeriods.DayPeriod.valueOf(x[2]);
            String nativeName = x[3].trim();
            DayInfo data = DATA.get(locale);
            if (data == null) {
                data = new DayInfo();
                DATA.put(locale, data);
            }
            data.locale = locale;
            for (int i = start; i < 24; ++i) {
                data.data[i] = dayPeriod;
            }
            String old = data.toNativeName.get((Object)dayPeriod);
            if (old != null && !old.equals(nativeName)) {
                throw new IllegalArgumentException(String.valueOf(locale) + " inconsistent native name for " + String.valueOf((Object)dayPeriod) + ", old: \u00ab" + old + "\u00bb, new: \u00ab" + nativeName + "\u00bb");
            }
            DayPeriods.DayPeriod oldDp = data.toDayPeriod.get(nativeName);
            if (oldDp != null && oldDp != dayPeriod) {
                throw new IllegalArgumentException(String.valueOf(locale) + " inconsistent day periods for name \u00ab" + nativeName + "\u00bb, old: " + String.valueOf((Object)oldDp) + ", new: " + String.valueOf((Object)dayPeriod));
            }
            data.toDayPeriod.put(nativeName, dayPeriod);
            data.toNativeName.put(dayPeriod, nativeName);
        }
        ROOT2 = new ULocale("root");
    }

    static class NoonMidnight {
        final String locale;
        final String noon;
        final String midnight;
        static Map<String, NoonMidnight> NOON_MIDNIGHT_MAP = new HashMap<String, NoonMidnight>();
        static final String[] NOON_MIDNIGHT = new String[]{"en|midnight|noon", "af|middernag|N/A", "nl|middernacht|N/A", "de|Mitternacht|N/A", "da|midnat|N/A", "no|midnatt|N/A", "sv|midnatt|N/A", "is|mi\u00f0n\u00e6tti|h\u00e1degi", "pt|meia-noite|meio-dia", "pt_PT|meia-noite|meio-dia", "gl|medianoite|mediod\u00eda", "es|medianoche|mediod\u00eda", "es_419|medianoche|mediod\u00eda", "ca|mitjanit|migdia", "it|mezzanotte|mezzogiorno", "ro|miezul nop\u021bii|amiaz\u0103", "fr|minuit|midi", "fr-CA|minuit|midi", "hr|pono\u0107|podne", "bs|u pono\u0107|u podne", "sr|\u043f\u043e\u043d\u043e\u045b|\u043f\u043e\u0434\u043d\u0435", "sl|polno\u010d|poldne", "cs|p\u016flnoc|poledne", "sk|polnoc|poludnie", "pl|p\u00f3\u0142noc|po\u0142udnie", "bg|\u043f\u043e\u043b\u0443\u043d\u043e\u0449|N/A", "mk|\u043d\u0430 \u043f\u043e\u043b\u043d\u043e\u045c|\u043d\u0430\u043f\u043b\u0430\u0434\u043d\u0435", "ru|\u043f\u043e\u043b\u043d\u043e\u0447\u044c|\u043f\u043e\u043b\u0434\u0435\u043d\u044c", "uk|\u043f\u0456\u0432\u043d\u0456\u0447|\u043f\u043e\u043b\u0443\u0434\u0435\u043d\u044c", "lt|vidurnaktis|vidurdienis", "lv|pusnakts|pusdienlaiks", "el|N/A|\u03bc\u03b5\u03c3\u03b7\u03bc\u03ad\u03c1\u03b9", "fa|\u0646\u06cc\u0645\u0647\u200c\u0634\u0628|\u0638\u0647\u0631", "hy|\u056f\u0565\u057d\u0563\u056b\u0577\u0565\u0580|\u056f\u0565\u057d\u0585\u0580", "ka|\u10e8\u10e3\u10d0\u10e6\u10d0\u10db\u10d4|\u10e8\u10e3\u10d0\u10d3\u10e6\u10d4", "sq|mesnat\u00eb|mesdit\u00eb", "ur|\u0622\u062f\u06be\u06cc \u0631\u0627\u062a|N/A", "hi|\u0906\u0927\u0940 \u0930\u093e\u0924|\u0926\u094b\u092a\u0939\u0930", "bn|N/A|N/A", "gu|\u0a85\u0aa1\u0aa7\u0ac0 \u0ab0\u0abe\u0aa4|\u0aac\u0aaa\u0acb\u0ab0", "mr|\u092e\u0927\u094d\u092f\u0930\u093e\u0924\u094d\u0930\u0940|\u092e\u0927\u094d\u092f\u093e\u0928\u094d\u0939", "ne|\u092e\u0927\u094d\u092f\u0930\u093e\u0924|\u092e\u0927\u094d\u092f\u093e\u0928\u094d\u0939", "pa|\u0a05\u0a71\u0a27\u0a40 \u0a30\u0a3e\u0a24|\u0a26\u0a41\u0a2a\u0a39\u0a3f\u0a30", "si|\u0db8\u0dd0\u0daf\u0dd2\u0dba\u0db8|\u0daf\u0dc0\u0dbd\u0dca", "ta|\u0ba8\u0bb3\u0bcd\u0bb3\u0bbf\u0bb0\u0bb5\u0bc1|\u0ba8\u0ba9\u0bcd\u0baa\u0b95\u0bb2\u0bcd", "te|\u0c05\u0c30\u0c4d\u0c25\u0c30\u0c3e\u0c24\u0c4d\u0c30\u0c3f|\u0c2e\u0c27\u0c4d\u0c2f\u0c3e\u0c39\u0c4d\u0c28\u0c02", "ml|\u0d05\u0d7c\u0d26\u0d4d\u0d27\u0d30\u0d3e\u0d24\u0d4d\u0d30\u0d3f|\u0d09\u0d1a\u0d4d\u0d1a\u0d2f\u0d4d\u0d15\u0d4d\u0d15\u0d4d", "kn|\u0cae\u0ca7\u0ccd\u0caf\u0cb0\u0cbe\u0ca4\u0ccd\u0cb0\u0cbf|\u0cae\u0ca7\u0ccd\u0caf\u0cbe\u0cb9\u0ccd\u0ca8", "zh|\u534a\u591c|\u4e2d\u5348", "zh-TW|\u5b50\u591c|\u6b63\u5348", "zh-HK|\u6df1\u591c|\u4e2d\u5348", "ja|\u771f\u591c\u4e2d|\u6b63\u5348", "ko|\uc790\uc815|\uc815\uc624", "tr|gece yar\u0131s\u0131|\u00f6\u011flen", "az|gec\u0259yar\u0131|g\u00fcnorta", "kk|\u0442\u04af\u043d \u0436\u0430\u0440\u044b\u043c\u044b|\u0442\u0430\u043b\u0442\u04af\u0441", "ky|\u0442\u04af\u043d \u043e\u0440\u0442\u043e\u0441\u0443|\u0447\u0430\u043a \u0442\u04af\u0448", "uz|yarim tun|tush", "et|kesk\u00f6\u00f6|keskp\u00e4ev", "fi|keskiy\u00f6|keskip\u00e4iv\u00e4", "hu|\u00e9jf\u00e9l|d\u00e9l", "th|\u0e40\u0e17\u0e35\u0e48\u0e22\u0e07\u0e04\u0e37\u0e19|\u0e40\u0e17\u0e35\u0e48\u0e22\u0e07", "lo|\u0e97\u0ec8\u0ebd\u0e87\u200b\u0e84\u0eb7\u0e99|\u200b\u0e97\u0ec8\u0ebd\u0e87", "ar| \u0645\u0646\u062a\u0635\u0641 \u0627\u0644\u0644\u064a\u0644|\u0638\u0647\u0631\u0627", "he|\u05d7\u05e6\u05d5\u05ea|N/A", "id|tengah malam|tengah hari", "ms|Tengah malam|Tengah hari", "fil|hating-gabi|tangaling-tapat", "vi|n\u1eeda \u0111\u00eam|tr\u01b0a", "km|\u17a2\u17b6\u1792\u17d2\u179a\u17b6\u178f\u17d2\u179a|\u1790\u17d2\u1784\u17c3\u200b\u178f\u17d2\u179a\u1784\u17cb", "sw|saa sita za usiku|saa sita za mchana", "zu|N/A|N/A", "am|\u12a5\u12a9\u1208 \u120c\u120a\u1275|\u1240\u1275\u122d", "eu|gauerdia|eguerdia", "mn|\u0448\u04e9\u043d\u04e9 \u0434\u0443\u043d\u0434|\u04af\u0434 \u0434\u0443\u043d\u0434", "my|\u101e\u1014\u103a\u1038\u1001\u1031\u102b\u1004\u103a\u101a\u1036|\u1019\u103d\u1014\u103a\u1038\u1010\u100a\u1037\u103a"};

        public NoonMidnight(List<String> items) {
            this.locale = items.get(0);
            this.midnight = CldrUtility.ifEqual(items.get(1), "N/A", null);
            this.noon = CldrUtility.ifEqual(items.get(2), "N/A", null);
        }

        static NoonMidnight get(String locale) {
            return NOON_MIDNIGHT_MAP.get(locale);
        }

        public String toString() {
            return this.locale + ", " + this.noon + ", " + this.midnight;
        }

        static {
            Splitter BAR = Splitter.on('|').trimResults();
            for (String s2 : NOON_MIDNIGHT) {
                List<String> items = BAR.splitToList(s2);
                NoonMidnight nm = new NoonMidnight(items);
                NOON_MIDNIGHT_MAP.put(items.get(0), nm);
            }
        }
    }

    static class DayInfo {
        ULocale locale;
        DayPeriods.DayPeriod[] data = new DayPeriods.DayPeriod[24];
        Map<DayPeriods.DayPeriod, String> toNativeName = new EnumMap<DayPeriods.DayPeriod, String>(DayPeriods.DayPeriod.class);
        Map<String, DayPeriods.DayPeriod> toDayPeriod = new HashMap<String, DayPeriods.DayPeriod>();

        DayInfo() {
        }

        public String toString() {
            String result = "make(\"" + String.valueOf(this.locale) + "\"";
            DayPeriods.DayPeriod lastDayPeriod = null;
            for (int i = 0; i < 24; ++i) {
                DayPeriods.DayPeriod dayPeriod = this.data[i];
                if (dayPeriod != lastDayPeriod) {
                    result = result + ")\n.add(\"" + String.valueOf((Object)dayPeriod) + "\", \"" + this.toNativeName.get((Object)dayPeriod) + "\"";
                    lastDayPeriod = dayPeriod;
                }
                result = result + ", " + i;
            }
            result = result + ")\n.build();\n";
            return result;
        }

        public String toCldr() {
            Object result = "\t\t<dayPeriodRules locales=\"" + String.valueOf(this.locale) + "\">\n";
            DayPeriods.DayPeriod lastDayPeriod = this.data[0];
            int start = 0;
            for (int i = 1; i < 24; ++i) {
                DayPeriods.DayPeriod dayPeriod = this.data[i];
                if (dayPeriod == lastDayPeriod) continue;
                result = this.addPeriod((String)result, lastDayPeriod, start, i);
                lastDayPeriod = dayPeriod;
                start = i;
            }
            result = this.addPeriod((String)result, lastDayPeriod, start, 24);
            result = (String)result + "\t\t</dayPeriodRules>";
            return result;
        }

        private String addPeriod(String result, DayPeriods.DayPeriod dayPeriod, int start, int i) {
            result = (String)result + "\t\t\t<dayPeriodRule type=\"" + dayPeriod.toString().toLowerCase(Locale.ENGLISH) + "\" from=\"" + start + ":00\" before=\"" + i + ":00\"/> <!-- " + this.toNativeName.get((Object)dayPeriod) + " -->\n";
            return result;
        }
    }
}

