/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.util.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DayPeriodInfo
implements Comparable<DayPeriodInfo> {
    public static final int HOUR = 3600000;
    public static final int MIDNIGHT = 0;
    public static final int NOON = 43200000;
    public static final int DAY_LIMIT = 86400000;
    private final Span[] spans;
    private final DayPeriod[] dayPeriods;
    final Relation<DayPeriod, Span> dayPeriodsToSpans = Relation.of(new EnumMap(DayPeriod.class), LinkedHashSet.class);
    private static final EnumMap<DayPeriod, EnumSet<DayPeriod>> allowableCollisions = new EnumMap(DayPeriod.class);

    private DayPeriodInfo(TreeSet<Span> info, String[] locales) {
        int len = info.size();
        this.spans = info.toArray(new Span[len]);
        ArrayList<DayPeriod> tempPeriods = new ArrayList<DayPeriod>();
        if (len != 0) {
            Span last = this.spans[0];
            tempPeriods.add(last.dayPeriod);
            this.dayPeriodsToSpans.put(last.dayPeriod, last);
            if (last.start != 0) {
                throw new IllegalArgumentException("Doesn't start at 0:00).");
            }
            for (int i = 1; i < len; ++i) {
                Span current = this.spans[i];
                if (current.start != current.end && last.start != last.end && current.start != last.end) {
                    throw new IllegalArgumentException("Gap or overlapping times:\t" + String.valueOf(current) + "\t" + String.valueOf(last) + "\t" + String.valueOf(Arrays.asList(locales)));
                }
                tempPeriods.add(current.dayPeriod);
                this.dayPeriodsToSpans.put(current.dayPeriod, current);
                last = current;
            }
            if (last.end != 86400000) {
                throw new IllegalArgumentException("Doesn't reach 24:00).");
            }
        }
        this.dayPeriods = tempPeriods.toArray(new DayPeriod[len]);
        this.dayPeriodsToSpans.freeze();
        for (Map.Entry<DayPeriod, Set<Span>> entry : this.dayPeriodsToSpans.keyValuesSet()) {
            DayPeriod dayPeriod = entry.getKey();
            Set<Span> spanSet = entry.getValue();
            if (spanSet.size() <= 0) continue;
            for (Span span : spanSet) {
                int start = span.start % 43200000;
                int end = span.getAdjustedEnd() % 43200000;
                for (Span span2 : spanSet) {
                    if (span2 == span) continue;
                    int start2 = span2.start % 43200000;
                    int end2 = span2.getAdjustedEnd() % 43200000;
                    if (start < end2 || start2 < end) continue;
                    throw new IllegalArgumentException("Overlapping times for " + String.valueOf((Object)dayPeriod) + ":\t" + String.valueOf(span) + "\t" + String.valueOf(span2) + "\t" + String.valueOf(Arrays.asList(locales)));
                }
            }
        }
    }

    @Override
    public int compareTo(DayPeriodInfo o) {
        int thisSpanCount = this.spans.length;
        int otherSpanCount = o.spans.length;
        if (thisSpanCount < otherSpanCount) {
            return -1;
        }
        if (thisSpanCount > otherSpanCount) {
            return 1;
        }
        for (int spanIndex = 0; spanIndex < thisSpanCount; ++spanIndex) {
            int result = this.spans[spanIndex].compareTo(o.spans[spanIndex]);
            if (0 != result) {
                return result;
            }
            result = this.dayPeriods[spanIndex].compareTo(o.dayPeriods[spanIndex]);
            if (0 == result) continue;
            return result;
        }
        return 0;
    }

    public int getFirstStartTime(DayPeriod dayPeriod) {
        for (int i = 0; i < this.spans.length; ++i) {
            if (this.spans[i].dayPeriod != dayPeriod) continue;
            return this.spans[i].start;
        }
        return -1;
    }

    public Row.R3<Integer, Integer, Boolean> getFirstDayPeriodInfo(DayPeriod dayPeriod) {
        Span span = this.getFirstDayPeriodSpan(dayPeriod);
        if (span == null) {
            return null;
        }
        return Row.of(span.start, span.end, true);
    }

    public Span getFirstDayPeriodSpan(DayPeriod dayPeriod) {
        switch (dayPeriod) {
            case am: {
                return DayPeriod.am.span;
            }
            case pm: {
                return DayPeriod.pm.span;
            }
        }
        Set<Span> spanList = this.dayPeriodsToSpans.get((Object)dayPeriod);
        return spanList == null ? null : this.dayPeriodsToSpans.get((Object)dayPeriod).iterator().next();
    }

    public Set<Span> getDayPeriodSpans(DayPeriod dayPeriod) {
        switch (dayPeriod) {
            case am: {
                return Collections.singleton(DayPeriod.am.span);
            }
            case pm: {
                return Collections.singleton(DayPeriod.pm.span);
            }
        }
        return this.dayPeriodsToSpans.get((Object)dayPeriod);
    }

    public DayPeriod getDayPeriod(int millisInDay) {
        if (millisInDay < 0) {
            throw new IllegalArgumentException("millisInDay too small");
        }
        if (millisInDay >= 86400000) {
            throw new IllegalArgumentException("millisInDay too big");
        }
        for (int i = 0; i < this.spans.length; ++i) {
            if (!this.spans[i].contains(millisInDay)) continue;
            return this.spans[i].dayPeriod;
        }
        throw new IllegalArgumentException("internal error");
    }

    public int getPeriodCount() {
        return this.spans.length;
    }

    public Row.R3<Integer, Boolean, DayPeriod> getPeriod(int index) {
        return Row.of(this.getSpan((int)index).start, true, this.getSpan((int)index).dayPeriod);
    }

    public Span getSpan(int index) {
        return this.spans[index];
    }

    public List<DayPeriod> getPeriods() {
        return Arrays.asList(this.dayPeriods);
    }

    public String toString() {
        return this.dayPeriodsToSpans.values().toString();
    }

    public String toString(DayPeriod dayPeriod) {
        switch (dayPeriod) {
            case midnight: {
                return "00:00";
            }
            case noon: {
                return "12:00";
            }
            case am: {
                return "00:00 \u2013 12:00\u207b";
            }
            case pm: {
                return "12:00 \u2013 24:00\u207b";
            }
        }
        StringBuilder result = new StringBuilder();
        Set<Span> set = this.dayPeriodsToSpans.get((Object)dayPeriod);
        if (set != null) {
            for (Span span : set) {
                if (span == null) continue;
                if (result.length() != 0) {
                    result.append("; ");
                }
                result.append(span.toStringPlain());
            }
        }
        return result.toString();
    }

    public static String formatTime(long time) {
        long minutes = time / 60000L;
        long hours = minutes / 60L;
        return String.format("%02d:%02d", hours, minutes -= hours * 60L);
    }

    public boolean collisionIsError(Type type1, DayPeriod dayPeriod1, Type type2, DayPeriod dayPeriod2, Output<Integer> sampleError) {
        DayPeriod flexible;
        DayPeriod fixedOrFlexible;
        if (dayPeriod1 == dayPeriod2) {
            return false;
        }
        if (allowableCollisions.containsKey((Object)dayPeriod1) && allowableCollisions.get((Object)dayPeriod1).contains((Object)dayPeriod2) || allowableCollisions.containsKey((Object)dayPeriod2) && allowableCollisions.get((Object)dayPeriod2).contains((Object)dayPeriod1)) {
            return false;
        }
        if ((dayPeriod1 == DayPeriod.night1 && (dayPeriod2 == DayPeriod.morning1 || dayPeriod2 == DayPeriod.am) || dayPeriod2 == DayPeriod.night1 && (dayPeriod1 == DayPeriod.morning1 || dayPeriod1 == DayPeriod.am)) && this.dayPeriodsToSpans.get((Object)DayPeriod.night1).size() == 1) {
            for (Span s2 : this.dayPeriodsToSpans.get((Object)DayPeriod.night1)) {
                if (s2.start != 0) continue;
                return false;
            }
        }
        if ((dayPeriod1 == DayPeriod.night1 && dayPeriod2 == DayPeriod.evening1 || dayPeriod2 == DayPeriod.night1 && dayPeriod1 == DayPeriod.evening1) && this.dayPeriodsToSpans.get((Object)DayPeriod.night1).size() == 1) {
            for (Span s2 : this.dayPeriodsToSpans.get((Object)DayPeriod.night1)) {
                if (s2.end != 86400000) continue;
                return false;
            }
        }
        if (type1 == Type.format && type2 == Type.format) {
            if (dayPeriod1 == DayPeriod.midnight && !dayPeriod2.isFixed()) {
                for (Span s2 : this.dayPeriodsToSpans.get((Object)dayPeriod2)) {
                    if (!s2.contains(0) && !s2.contains(86400000)) continue;
                    return false;
                }
            }
            if (dayPeriod2 == DayPeriod.midnight && !dayPeriod1.isFixed()) {
                for (Span s2 : this.dayPeriodsToSpans.get((Object)dayPeriod1)) {
                    if (!s2.contains(0) && !s2.contains(86400000)) continue;
                    return false;
                }
            }
            if (dayPeriod1 == DayPeriod.noon && !dayPeriod2.isFixed()) {
                for (Span s2 : this.dayPeriodsToSpans.get((Object)dayPeriod2)) {
                    if (!s2.contains(43200000) && !s2.contains(43199999)) continue;
                    return false;
                }
            }
            if (dayPeriod2 == DayPeriod.noon && !dayPeriod1.isFixed()) {
                for (Span s2 : this.dayPeriodsToSpans.get((Object)dayPeriod1)) {
                    if (!s2.contains(43200000) && !s2.contains(43199999)) continue;
                    return false;
                }
            }
        }
        if (type2 == Type.format) {
            type1 = Type.format;
        }
        boolean fixed1 = dayPeriod1.isFixed();
        boolean fixed2 = dayPeriod2.isFixed();
        if (fixed1 && fixed2) {
            return true;
        }
        if (fixed1) {
            fixedOrFlexible = dayPeriod1;
            flexible = dayPeriod2;
        } else {
            fixedOrFlexible = dayPeriod2;
            flexible = dayPeriod1;
        }
        switch (type1) {
            case format: {
                if (fixedOrFlexible.span != null) {
                    if (!this.collisionIsErrorFormat(flexible, fixedOrFlexible.span, sampleError)) break;
                    return true;
                }
                for (Span s3 : this.dayPeriodsToSpans.get((Object)fixedOrFlexible)) {
                    if (!this.collisionIsErrorFormat(flexible, s3, sampleError)) continue;
                    return true;
                }
                break;
            }
            case selection: {
                if (fixedOrFlexible.span != null) {
                    if (!this.collisionIsErrorSelection(flexible, fixedOrFlexible.span, sampleError)) break;
                    return true;
                }
                for (Span s4 : this.dayPeriodsToSpans.get((Object)fixedOrFlexible)) {
                    if (!this.collisionIsErrorSelection(flexible, s4, sampleError)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private boolean collisionIsErrorFormat(DayPeriod dayPeriod, Span other, Output<Integer> sampleError) {
        int otherStart = other.start % 43200000;
        int otherEnd = other.getAdjustedEnd() % 43200000;
        for (Span s2 : this.dayPeriodsToSpans.get((Object)dayPeriod)) {
            int flexStart = s2.start % 43200000;
            int flexEnd = s2.getAdjustedEnd() % 43200000;
            if (otherStart > flexEnd || otherEnd < flexStart) continue;
            if (sampleError != null) {
                sampleError.value = Math.max(otherStart, otherEnd);
            }
            return true;
        }
        return false;
    }

    private boolean collisionIsErrorSelection(DayPeriod dayPeriod, Span other, Output<Integer> sampleError) {
        int otherStart = other.start;
        int otherEnd = other.getAdjustedEnd();
        for (Span s2 : this.dayPeriodsToSpans.get((Object)dayPeriod)) {
            int flexStart = s2.start;
            int flexEnd = s2.getAdjustedEnd();
            if (otherStart != flexStart) {
                if (sampleError != null) {
                    sampleError.value = (otherStart + flexStart) / 2;
                }
                return true;
            }
            if (otherEnd == flexEnd) continue;
            if (sampleError != null) {
                sampleError.value = (otherEnd + flexEnd) / 2;
            }
            return true;
        }
        return false;
    }

    static {
        allowableCollisions.put(DayPeriod.am, EnumSet.of(DayPeriod.morning1, DayPeriod.morning2));
        allowableCollisions.put(DayPeriod.pm, EnumSet.of(DayPeriod.afternoon1, DayPeriod.afternoon2, DayPeriod.evening1, DayPeriod.evening2));
    }

    public static class Builder {
        TreeSet<Span> info = new TreeSet();

        public Builder add(DayPeriod dayPeriod, int start, boolean includesStart, int end, boolean includesEnd) {
            if (dayPeriod == null || start < 0 || start > end || end > 86400000 || end - start > 43200000) {
                throw new IllegalArgumentException("Bad data");
            }
            Span span = new Span(start, end, dayPeriod);
            boolean didntContain = this.info.add(span);
            if (!didntContain) {
                throw new IllegalArgumentException("Duplicate data: " + String.valueOf(span));
            }
            return this;
        }

        public DayPeriodInfo finish(String[] locales) {
            DayPeriodInfo result = new DayPeriodInfo(this.info, locales);
            this.info.clear();
            return result;
        }

        public boolean contains(DayPeriod dayPeriod) {
            for (Span span : this.info) {
                if (span.dayPeriod != dayPeriod) continue;
                return true;
            }
            return false;
        }
    }

    public static enum DayPeriod {
        midnight(0, 0),
        am(0, 43200000),
        noon(43200000, 43200000),
        pm(43200000, 86400000),
        morning1,
        morning2,
        afternoon1,
        afternoon2,
        evening1,
        evening2,
        night1,
        night2;

        public final Span span;

        private DayPeriod(int start, int end) {
            this.span = new Span(start, end, this);
        }

        private DayPeriod() {
            this.span = null;
        }

        public static DayPeriod fromString(String value) {
            return DayPeriod.valueOf(value);
        }

        public boolean isFixed() {
            return this.span != null;
        }
    }

    public static class Span
    implements Comparable<Span> {
        public final int start;
        public final int end;
        public final boolean includesEnd;
        public final DayPeriod dayPeriod;

        public Span(int start, int end, DayPeriod dayPeriod) {
            this.start = start;
            this.end = end;
            this.includesEnd = start == end;
            this.dayPeriod = dayPeriod;
        }

        @Override
        public int compareTo(Span o) {
            int diff = this.start - o.start;
            if (diff != 0) {
                return diff;
            }
            diff = this.end - o.end;
            if (diff != 0) {
                return diff;
            }
            return 0;
        }

        public boolean contains(int millisInDay) {
            return this.start <= millisInDay && (millisInDay < this.end || millisInDay == this.end && this.includesEnd);
        }

        public int getAdjustedEnd() {
            return this.includesEnd ? this.end : this.end - 1;
        }

        public boolean equals(Object obj) {
            Span other = (Span)obj;
            return this.start == other.start && this.end == other.end;
        }

        public int hashCode() {
            return this.start * 37 + this.end;
        }

        public String toString() {
            return String.valueOf((Object)this.dayPeriod) + ":" + this.toStringPlain();
        }

        public String toStringPlain() {
            return DayPeriodInfo.formatTime(this.start) + " \u2013 " + DayPeriodInfo.formatTime(this.end) + (this.includesEnd ? "" : "\u207b");
        }
    }

    public static enum Type {
        format("format"),
        selection("stand-alone");

        public final String pathValue;

        private Type(String _pathValue) {
            this.pathValue = _pathValue;
        }

        public static Type fromString(String source) {
            return Type.selection.pathValue.equals(source) ? selection : Type.valueOf(source);
        }
    }
}

