/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.DoctypeXmlStreamWrapper;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.PatternCache;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;

public class ElementAttributeInfo {
    private DtdType dtdType;
    private Map<Row.R2<String, String>, Row.R3<Set<String>, String, String>> elementAttribute2Data = new TreeMap<Row.R2<String, String>, Row.R3<Set<String>, String, String>>();
    private Relation<String, String> element2children = Relation.of(new LinkedHashMap(), LinkedHashSet.class);
    private Relation<String, String> element2parents = Relation.of(new LinkedHashMap(), LinkedHashSet.class);
    private Relation<String, String> element2attributes = Relation.of(new LinkedHashMap(), LinkedHashSet.class);
    static Map<String, Map<DtdType, ElementAttributeInfo>> cache = new HashMap<String, Map<DtdType, ElementAttributeInfo>>();

    public static final ElementAttributeInfo getInstance(DtdType dtdType) {
        return ElementAttributeInfo.getInstance(CLDRPaths.COMMON_DIRECTORY, dtdType);
    }

    public static final ElementAttributeInfo getInstance(String commonDirectory, DtdType dtdType) {
        ElementAttributeInfo eai;
        Map<DtdType, ElementAttributeInfo> result = cache.get(commonDirectory);
        if (result == null) {
            try {
                File file = new File(commonDirectory);
                String canonicalCommonDirectory = file.getCanonicalFile().toString();
                if (!commonDirectory.equals(canonicalCommonDirectory) && (result = cache.get(commonDirectory)) != null) {
                    cache.put(commonDirectory, result);
                }
                if (result == null) {
                    result = ElementAttributeInfo.makeElementAttributeInfoMap(canonicalCommonDirectory);
                    cache.put(commonDirectory, result);
                    cache.put(canonicalCommonDirectory, result);
                }
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException(e);
            }
        }
        if ((eai = result.get((Object)dtdType)) == null) {
            throw new NullPointerException("ElementAttributeInfo.getInstance(\u2026," + dtdType.name() + ") returns null, please update this function");
        }
        return eai;
    }

    private static void addElementAttributeInfo(Map<DtdType, ElementAttributeInfo> result, DtdType type, String path) throws IOException {
        if (!new File(path).canRead()) {
            System.err.println("ElementAttributeInfo: Warning: Sample file did not exist: " + path + " for DtdType " + type.name());
            return;
        }
        result.put(type, new ElementAttributeInfo(path, type));
    }

    private static Map<DtdType, ElementAttributeInfo> makeElementAttributeInfoMap(String canonicalCommonDirectory) throws IOException {
        HashMap<DtdType, ElementAttributeInfo> result = new HashMap<DtdType, ElementAttributeInfo>();
        ElementAttributeInfo.addElementAttributeInfo(result, DtdType.ldml, canonicalCommonDirectory + "/main/root.xml");
        ElementAttributeInfo.addElementAttributeInfo(result, DtdType.supplementalData, canonicalCommonDirectory + "/supplemental/plurals.xml");
        ElementAttributeInfo.addElementAttributeInfo(result, DtdType.ldmlBCP47, canonicalCommonDirectory + "/bcp47/calendar.xml");
        ElementAttributeInfo.addElementAttributeInfo(result, DtdType.keyboard3, canonicalCommonDirectory + "/../keyboards/3.0/fr-t-k0-test.xml");
        ElementAttributeInfo.addElementAttributeInfo(result, DtdType.keyboardTest3, canonicalCommonDirectory + "/../keyboards/test/fr-t-k0-test-test.xml");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElementAttributeInfo(String filename, DtdType type) throws IOException {
        try (FileInputStream fis = new FileInputStream(filename);){
            XMLReader xmlReader = CLDRFile.createXMLReader(true);
            this.dtdType = type;
            MyDeclHandler me = new MyDeclHandler(this);
            xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", me);
            InputSource is = new InputSource(fis);
            is.setSystemId(filename);
            xmlReader.parse(DoctypeXmlStreamWrapper.wrap(is));
            this.elementAttribute2Data = Collections.unmodifiableMap(this.getElementAttribute2Data());
            this.getElement2Children().freeze();
            this.getElement2Parents().freeze();
            this.getElement2Attributes().freeze();
        }
    }

    private DtdType getDtdType() {
        return this.dtdType;
    }

    public Map<Row.R2<String, String>, Row.R3<Set<String>, String, String>> getElementAttribute2Data() {
        return this.elementAttribute2Data;
    }

    public Relation<String, String> getElement2Children() {
        return this.element2children;
    }

    public Relation<String, String> getElement2Parents() {
        return this.element2parents;
    }

    public Relation<String, String> getElement2Attributes() {
        return this.element2attributes;
    }

    static class MyDeclHandler
    implements DeclHandler {
        private static final boolean SHOW = false;
        private ElementAttributeInfo myData;
        Matcher idmatcher = PatternCache.get("[a-zA-Z0-9][-_a-zA-Z0-9]*").matcher("");

        public MyDeclHandler(ElementAttributeInfo indata) {
            this.myData = indata;
        }

        @Override
        public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
            Row.R2<String, String> key = Row.of(eName, aName);
            Set<String> typeSet = this.getIdentifiers(type);
            Row.R3<Set<String>, String, String> value2 = Row.of(typeSet, mode, value);
            Row.R3<Set<String>, String, String> oldValue = this.myData.getElementAttribute2Data().get(key);
            if (oldValue != null && !oldValue.equals(value2)) {
                throw new IllegalArgumentException("Conflict in data: " + String.valueOf(key) + "\told: " + String.valueOf(oldValue) + "\tnew: " + String.valueOf(value2));
            }
            this.myData.getElementAttribute2Data().put(key, value2);
            this.myData.getElement2Attributes().put(eName, aName);
        }

        private Set<String> getIdentifiers(String type) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            this.idmatcher.reset(type);
            while (this.idmatcher.find()) {
                result.add(this.idmatcher.group());
            }
            if (result.size() == 0) {
                throw new IllegalArgumentException("No identifiers found in: " + type);
            }
            return result;
        }

        @Override
        public void elementDecl(String name, String model) throws SAXException {
            Set<String> identifiers = this.getIdentifiers(model);
            if (identifiers.size() == 0) {
                identifiers.add("EMPTY");
            }
            this.myData.getElement2Children().putAll(name, identifiers);
            for (String identifier : identifiers) {
                this.myData.getElement2Parents().put(identifier, name);
            }
        }

        @Override
        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void internalEntityDecl(String name, String value) throws SAXException {
        }
    }
}

