/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Locale;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.StandardCodes;

public enum NameType {
    NONE("", ""),
    LANGUAGE("//ldml/localeDisplayNames/languages/language[@type=\"", "\"]"),
    SCRIPT("//ldml/localeDisplayNames/scripts/script[@type=\"", "\"]"),
    TERRITORY("//ldml/localeDisplayNames/territories/territory[@type=\"", "\"]"),
    VARIANT("//ldml/localeDisplayNames/variants/variant[@type=\"", "\"]"),
    CURRENCY("//ldml/numbers/currencies/currency[@type=\"", "\"]/displayName"),
    CURRENCY_SYMBOL("//ldml/numbers/currencies/currency[@type=\"", "\"]/symbol"),
    TZ_EXEMPLAR("//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/exemplarCity"),
    TZ_GENERIC_LONG("//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/long/generic"),
    TZ_GENERIC_SHORT("//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/short/generic"),
    TZ_STANDARD_LONG("//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/long/standard"),
    TZ_STANDARD_SHORT("//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/short/standard"),
    TZ_DAYLIGHT_LONG("//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/long/daylight"),
    TZ_DAYLIGHT_SHORT("//ldml/dates/timeZoneNames/zone[@type=\"", "\"]/short/daylight"),
    KEY("//ldml/localeDisplayNames/keys/key[@type=\"", "\"]"),
    KEY_TYPE("//ldml/localeDisplayNames/types/type[@key=\"", "\"][@type=\"", "\"]"),
    SUBDIVISION("//ldml/localeDisplayNames/subdivisions/subdivision[@type=\"", "\"]");

    private final String first;
    private final String second;
    private final String third;
    private static final ImmutableMap<String, String> FIX_KEY_NAME;

    private NameType(String first, String second) {
        this(first, second, "");
    }

    private NameType(String first, String second, String third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public StandardCodes.CodeType toCodeType() {
        switch (this) {
            case LANGUAGE: {
                return StandardCodes.CodeType.language;
            }
            case SCRIPT: {
                return StandardCodes.CodeType.script;
            }
            case TERRITORY: {
                return StandardCodes.CodeType.territory;
            }
            case VARIANT: {
                return StandardCodes.CodeType.variant;
            }
            case CURRENCY: 
            case CURRENCY_SYMBOL: {
                return StandardCodes.CodeType.currency;
            }
            case TZ_EXEMPLAR: {
                return StandardCodes.CodeType.tzid;
            }
        }
        throw new IllegalArgumentException("Unsupported name type");
    }

    public static NameType fromPath(String xpath) {
        for (NameType nameType : NameType.values()) {
            if (nameType == NONE || !xpath.startsWith(nameType.first) || xpath.indexOf(nameType.second, nameType.first.length()) < 0) continue;
            return nameType;
        }
        return NONE;
    }

    public String getKeyPath(String code) {
        if ((code = this.fixCode(code)).contains("|")) {
            if (!KEY_TYPE.equals((Object)this)) {
                throw new IllegalArgumentException("Bar code is only for KEY_TYPE");
            }
            String[] codes = code.split("\\|");
            return this.first + NameType.fixKeyName(codes[0]) + this.second + codes[1] + this.third;
        }
        return this.first + code + this.second;
    }

    private String fixCode(String code) {
        switch (this) {
            case VARIANT: {
                return code.toUpperCase(Locale.ROOT);
            }
            case KEY: {
                return NameType.fixKeyName(code);
            }
            case TZ_EXEMPLAR: 
            case TZ_DAYLIGHT_LONG: 
            case TZ_DAYLIGHT_SHORT: 
            case TZ_GENERIC_LONG: 
            case TZ_GENERIC_SHORT: 
            case TZ_STANDARD_LONG: 
            case TZ_STANDARD_SHORT: {
                return CLDRFile.getLongTzid(code);
            }
        }
        return code;
    }

    private static String fixKeyName(String code) {
        String result = FIX_KEY_NAME.get(code);
        return result == null ? code : result;
    }

    public static String getCode(String path) {
        NameType nameType = NameType.fromPath(path);
        if (nameType == NONE) {
            throw new IllegalArgumentException("Illegal type in path: " + path);
        }
        int start = nameType.first.length();
        int end = path.indexOf(nameType.second, start);
        return path.substring(start, end);
    }

    public static NameType typeNameToCode(String typeString) {
        String s2 = typeString.toUpperCase().replace("-", "_");
        try {
            return NameType.valueOf(s2);
        }
        catch (IllegalArgumentException e) {
            switch (s2) {
                case "EXEMPLAR_CITY": {
                    return TZ_EXEMPLAR;
                }
                case "KEY|TYPE": {
                    return KEY_TYPE;
                }
                case "REGION": {
                    return TERRITORY;
                }
            }
            return NONE;
        }
    }

    public String getPathStart() {
        return this.first;
    }

    static {
        ImmutableMap.Builder<String, String> temp = ImmutableMap.builder();
        for (String s2 : Arrays.asList("colAlternate", "colBackwards", "colCaseFirst", "colCaseLevel", "colNormalization", "colNumeric", "colReorder", "colStrength")) {
            temp.put(s2.toLowerCase(Locale.ROOT), s2);
        }
        FIX_KEY_NAME = temp.build();
    }
}

