/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.UTF16;

public abstract class Quoter {
    private static boolean DEBUG = false;
    protected boolean quoting = false;
    protected StringBuilder output = new StringBuilder();

    public void setQuoting(boolean value) {
        this.quoting = value;
    }

    public boolean isQuoting() {
        return this.quoting;
    }

    public void clear() {
        this.quoting = false;
        this.output.setLength(0);
    }

    public int length() {
        return this.output.length();
    }

    public Quoter append(String string) {
        this.output.append(string);
        return this;
    }

    public Quoter append(int codepoint) {
        return this.append(UTF16.valueOf(codepoint));
    }

    public String toString() {
        this.setQuoting(false);
        return this.output.toString();
    }

    public static class RuleQuoter
    extends Quoter {
        private StringBuilder quoteBuffer = new StringBuilder();

        @Override
        public void setQuoting(boolean value) {
            if (this.quoting == value) {
                return;
            }
            if (this.quoting) {
                Utility.appendToRule(this.output, -1, true, false, this.quoteBuffer);
            }
            this.quoting = value;
        }

        @Override
        public Quoter append(String s2) {
            if (DEBUG) {
                System.out.println("\"" + s2 + "\"");
            }
            if (this.quoting) {
                Utility.appendToRule(this.output, s2, false, false, this.quoteBuffer);
            } else {
                this.output.append(s2);
            }
            return this;
        }
    }
}

