/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CldrUtility;

public class SpreadSheet {
    static boolean DEBUG = CldrUtility.getProperty("SpreadSheetDebug", false);

    public static List<List<String>> convert(String filename) throws IOException {
        return SpreadSheet.convert(FileUtilities.openUTF8Reader("", filename));
    }

    public static List<List<String>> convert(BufferedReader r) throws IOException {
        String line;
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        while ((line = r.readLine()) != null) {
            if (line.startsWith("#")) continue;
            if (DEBUG) {
                System.out.println("Spreadsheet:\t" + line);
            }
            String[] parts = line.split("\t");
            ArrayList<String> row = new ArrayList<String>(parts.length);
            for (String part : parts) {
                if (part.startsWith("\"") && part.endsWith("\"")) {
                    row.add(part.substring(1, part.length() - 1));
                    continue;
                }
                row.add(part);
            }
            result.add(row);
        }
        return result;
    }
}

