/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.UnicodeSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class UnicodeSets {
    public static Set<String> getRedundantStrings(UnicodeSet source) {
        Collection<String> strings = source.strings();
        if (strings.isEmpty()) {
            return Collections.emptySet();
        }
        Set<String> result = null;
        block0: for (String s2 : strings) {
            int cp;
            for (int i = 0; i < s2.length(); i += Character.charCount(cp)) {
                cp = s2.codePointAt(i);
                if (!source.contains(cp)) continue block0;
            }
            if (result == null) {
                result = new HashSet();
            }
            result.add(s2);
        }
        if (result == null) {
            result = Collections.emptySet();
        }
        UnicodeSet remaining = new UnicodeSet(source);
        remaining.removeAll(result);
        for (String s3 : remaining.strings()) {
            UnicodeSet temp = new UnicodeSet(remaining).remove(s3);
            int position = temp.span(s3, UnicodeSet.SpanCondition.CONTAINED);
            if (position != s3.length()) continue;
            result.add(s3);
        }
        return result;
    }
}

