/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util.props;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.Transform;
import com.ibm.icu.text.UTF16;

public abstract class UnicodeLabel
implements Transform<Integer, String> {
    public static final UnicodeLabel NULL = new Constant("");
    public static final UnicodeLabel HEX = new Hex();

    public abstract String getValue(int var1, boolean var2);

    @Override
    public String transform(Integer codepoint) {
        return this.getValue(codepoint, true);
    }

    public String getValue(String s2, String separator, boolean withCodePoint) {
        int cp;
        if (s2.length() == 1) {
            return this.getValue(s2.charAt(0), withCodePoint);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s2.length(); i += UTF16.getCharCount(cp)) {
            cp = UTF16.charAt(s2, i);
            if (i != 0) {
                sb.append(separator);
            }
            sb.append(this.getValue(cp, withCodePoint));
        }
        return sb.toString();
    }

    public int getMaxWidth(boolean isShort) {
        return 0;
    }

    public static class Constant
    extends UnicodeLabel {
        private String value;

        public Constant(String value) {
            if (value == null) {
                value = "";
            }
            this.value = value;
        }

        @Override
        public String getValue(int codepoint, boolean isShort) {
            return this.value;
        }

        @Override
        public int getMaxWidth(boolean isShort) {
            return this.value.length();
        }
    }

    private static class Hex
    extends UnicodeLabel {
        private Hex() {
        }

        @Override
        public String getValue(int codepoint, boolean isShort) {
            if (isShort) {
                return Utility.hex(codepoint, 4);
            }
            return "U+" + Utility.hex(codepoint, 4);
        }
    }
}

