/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.text.StringTransform;
import com.ibm.icu.text.UnicodeSet;
import org.unicode.cldr.draft.FilteredTransform;

public class UnicodeSetFilteredTransform
extends FilteredTransform {
    private final UnicodeSet unicodeSet;

    public UnicodeSetFilteredTransform(UnicodeSet filter, StringTransform result) {
        super(result);
        this.unicodeSet = filter.freeze();
    }

    @Override
    protected boolean getNextRegion(String text, int[] startEnd) {
        block5: {
            int cp;
            int i;
            int length;
            block4: {
                length = text.length();
                if (length <= i) {
                    return false;
                }
                for (i = startEnd[1]; i < length; i += Character.charCount(cp)) {
                    cp = text.codePointAt(i);
                    if (!this.unicodeSet.contains(cp)) continue;
                    startEnd[0] = i;
                    break block4;
                }
                startEnd[0] = startEnd[1] = i;
                return true;
            }
            while (i < length) {
                cp = text.codePointAt(i);
                if (!this.unicodeSet.contains(cp)) {
                    startEnd[1] = i;
                    break block5;
                }
                i += Character.charCount(cp);
            }
            startEnd[1] = i;
        }
        return true;
    }

    @Override
    public String toString() {
        return ":: " + this.unicodeSet.toPattern(false) + ";\n" + super.toString();
    }
}

