/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu.text;

import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GenderInfo {
    private final ListGenderStyle style;
    private static Map<ULocale, ListGenderStyle> localeToListGender = new HashMap<ULocale, ListGenderStyle>();

    public GenderInfo(ULocale uLocale) {
        ULocale language = new ULocale(uLocale.getLanguage());
        ListGenderStyle tempStyle = localeToListGender.get(language);
        this.style = tempStyle == null ? ListGenderStyle.NEUTRAL : tempStyle;
    }

    public GenderInfo(Locale locale) {
        this(ULocale.forLocale(locale));
    }

    public static void setLocaleMapping(Map<ULocale, ListGenderStyle> newULocaleToListGender) {
        localeToListGender.clear();
        for (Map.Entry<ULocale, ListGenderStyle> entry : newULocaleToListGender.entrySet()) {
            localeToListGender.put(entry.getKey(), entry.getValue());
        }
    }

    public Gender getListGender(Gender ... genders) {
        return this.getListGender(Arrays.asList(genders));
    }

    public Gender getListGender(List<Gender> genders) {
        if (genders.size() == 0 || this.style == ListGenderStyle.NEUTRAL) {
            return Gender.OTHER;
        }
        if (genders.size() == 1) {
            return genders.get(0);
        }
        switch (this.style) {
            case MIXED_NEUTRAL: {
                boolean hasFemale = false;
                boolean hasMale = false;
                for (Gender gender : genders) {
                    switch (gender) {
                        case FEMALE: {
                            if (hasMale) {
                                return Gender.OTHER;
                            }
                            hasFemale = true;
                            break;
                        }
                        case MALE: {
                            if (hasFemale) {
                                return Gender.OTHER;
                            }
                            hasMale = true;
                            break;
                        }
                        case OTHER: {
                            return Gender.OTHER;
                        }
                    }
                }
                return hasMale ? Gender.MALE : (hasFemale ? Gender.FEMALE : Gender.OTHER);
            }
            case MALE_TAINTS: {
                for (Gender gender : genders) {
                    if (gender == Gender.FEMALE) continue;
                    return Gender.MALE;
                }
                return Gender.FEMALE;
            }
        }
        return Gender.OTHER;
    }

    static {
        for (String locale : Arrays.asList("ar", "ca", "cs", "hr", "es", "fr", "he", "hi", "it", "lt", "lv", "mr", "nl", "pl", "pt", "ro", "ru", "sk", "sl", "sr", "uk", "ur", "zh")) {
            localeToListGender.put(new ULocale(locale), ListGenderStyle.MALE_TAINTS);
        }
        for (String locale : Arrays.asList("el", "is")) {
            localeToListGender.put(new ULocale(locale), ListGenderStyle.MIXED_NEUTRAL);
        }
    }

    public static enum ListGenderStyle {
        NEUTRAL,
        MIXED_NEUTRAL,
        MALE_TAINTS;

    }

    public static enum Gender {
        MALE,
        FEMALE,
        OTHER;

    }
}

