/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.XPathParts;

class FlexibleDateFromCLDR {
    DateTimePatternGenerator gen = DateTimePatternGenerator.getEmptyInstance();
    private transient ICUServiceBuilder icuServiceBuilder = new ICUServiceBuilder();
    static List<String> tests = Arrays.asList("HHmmssSSSvvvv", "HHmm", "HHmmvvvv", "HHmmss", "HHmmssSSSSS", "HHmmssvvvv", "MMMd", "Md", "YYYYD", "yyyyww", "yyyywwEEE", "yyyyQQQQ", "yyyyMM", "yyyyMd", "yyyyMMMd", "yyyyMMMEEEd", "GyyyyMMMd", "GyyyyMMMEEEd", "YYYYwEEE", "yyyyDD", "yyyyMMFE", "eG", "dMMy", "GHHmm", "yyyyHHmm", "Kmm", "kmm", "MMdd", "ddHH", "yyyyMMMd", "yyyyMMddHHmmss", "GEEEEyyyyMMddHHmmss", "GuuuuQMMMMwwWddDDDFEEEEaHHmmssSSSvvvv");
    Map<String, String> failureMap = new TreeMap<String, String>();
    private static String DATE_FORMAT_ITEM_ID_PREFIX = "dateFormatItem[@id=\"";
    DateTimePatternGenerator.FormatParser fp = new DateTimePatternGenerator.FormatParser();
    boolean isPreferred12Hour = false;
    private static String[] DISPLAY_NAME_MAP = new String[]{"era", "year", "quarter", "month", "week", "week_in_month", "weekday", "day", "day_of_year", "day_of_week_in_month", "dayperiod", "hour", "minute", "second", "fractional_second", "zone", "-"};
    private static String[] APPEND_ITEM_NAME_MAP = new String[]{"Era", "Year", "Quarter", "Month", "Week", "Week", "Day-Of-Week", "Day", "Day", "Day-Of-Week", "-", "Hour", "Minute", "Second", "-", "Timezone", "-"};
    DateTimePatternGenerator.PatternInfo patternInfo = new DateTimePatternGenerator.PatternInfo();

    FlexibleDateFromCLDR() {
    }

    public void set(CLDRFile cldrFile) {
        this.icuServiceBuilder.setCldrFile(cldrFile);
        this.gen = DateTimePatternGenerator.getEmptyInstance();
        this.failureMap.clear();
    }

    public void showFlexibles() {
        Map<String, String> items = this.gen.getSkeletons(new LinkedHashMap<String, String>());
        System.out.println("ERRORS");
        for (String item : this.failureMap.keySet()) {
            String value = this.failureMap.get(item);
            System.out.println("\t" + value);
        }
        for (int i = 0; i < 16; ++i) {
            String name;
            String format = this.gen.getAppendItemFormat(i);
            if (format.indexOf(9500) >= 0) {
                System.out.println("\tMissing AppendItem format:\t" + DISPLAY_NAME_MAP[i]);
            }
            if (i == 14 || !(name = this.gen.getAppendItemName(i)).matches("F[0-9]+")) continue;
            System.out.println("\tMissing Field Name:\t" + DISPLAY_NAME_MAP[i]);
        }
        System.out.println("SKELETON\t=> PATTERN LIST");
        for (String skeleton : items.keySet()) {
            System.out.println("\t\"" + skeleton + "\"\t=>\t\"" + items.get(skeleton) + "\"");
        }
        System.out.println("REDUNDANTS");
        Collection<String> redundants = this.gen.getRedundants(new ArrayList<String>());
        for (String item : redundants) {
            System.out.println("\t" + item);
        }
        System.out.println("TESTS");
        for (String item : tests) {
            try {
                String pat = this.gen.getBestPattern(item);
                String sample = "<can't format>";
                try {
                    SimpleDateFormat df = this.icuServiceBuilder.getDateFormat("gregorian", pat);
                    sample = df.format(new Date());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                System.out.println("\t\"" + item + "\"\t=>\t\"" + pat + "\"\t=>\t\"" + sample + "\"");
            }
            catch (RuntimeException e) {
                System.out.println(e.getMessage());
            }
        }
        System.out.println("END");
    }

    public void checkFlexibles(String path, String value, String fullPath) {
        if (path.indexOf("numbers/symbols[@numberSystem=\"latn\"]/decimal") >= 0) {
            this.gen.setDecimal(value);
            return;
        }
        if (path.indexOf("gregorian") < 0) {
            return;
        }
        if (path.indexOf("/appendItem") >= 0) {
            XPathParts parts = XPathParts.getFrozenInstance(path);
            String key = parts.getAttributeValue(-1, "request");
            try {
                this.gen.setAppendItemFormat(this.getIndex(key, APPEND_ITEM_NAME_MAP), value);
            }
            catch (RuntimeException e) {
                this.failureMap.put(path, "\tWarning: can't set AppendItemFormat:\t" + key + ":\t" + value);
            }
            return;
        }
        if (path.indexOf("/fields") >= 0) {
            XPathParts parts = XPathParts.getFrozenInstance(path);
            String key = parts.getAttributeValue(-2, "type");
            try {
                this.gen.setAppendItemName(this.getIndex(key, DISPLAY_NAME_MAP), value);
            }
            catch (RuntimeException e) {
                this.failureMap.put(path, "\tWarning: can't set AppendItemName:\t" + key + ":\t" + value);
            }
            return;
        }
        if (path.indexOf("pattern") < 0 && path.indexOf("dateFormatItem") < 0 && path.indexOf("intervalFormatItem") < 0) {
            return;
        }
        if (path.indexOf("timeFormatLength[@type=\"short\"]") >= 0) {
            this.fp.set(value);
            for (Object item : this.fp.getItems()) {
                if (!(item instanceof DateTimePatternGenerator.VariableField) || item.toString().charAt(0) != 'h') continue;
                this.isPreferred12Hour = true;
            }
        }
        if (path.indexOf("dateTimeFormatLength") > 0) {
            return;
        }
        if (path.indexOf("intervalFormatItem") < 0) {
            try {
                this.gen.addPattern(value, false, this.patternInfo);
                switch (this.patternInfo.status) {
                    case 2: {
                        this.failureMap.put(path, "Conflicting Patterns: \"" + value + "\"\t&\t\"" + this.patternInfo.conflictingPattern + "\"");
                    }
                }
            }
            catch (RuntimeException e) {
                this.failureMap.put(path, e.getMessage());
            }
        }
    }

    public DateTimePatternGenerator getDTPGForCalendarType(String calendarType, List<CLDRFile> parentCLDRFiles) {
        DateTimePatternGenerator dtpg = DateTimePatternGenerator.getEmptyInstance();
        switch (calendarType) {
            default: {
                this.addAvailableFormatsForFile(dtpg, calendarType, parentCLDRFiles.get(0));
                int hyphenIndex = calendarType.indexOf(45);
                if (hyphenIndex > 0) {
                    String baseType = calendarType.substring(0, hyphenIndex);
                    this.addAvailableFormatsForFile(dtpg, baseType, parentCLDRFiles.get(0));
                }
            }
            case "generic": {
                this.addAvailableFormatsForFile(dtpg, "generic", parentCLDRFiles.get(0));
            }
            case "gregorian": {
                this.addAvailableFormatsWithParents(dtpg, "gregorian", parentCLDRFiles);
                break;
            }
            case "dangi": {
                this.addAvailableFormatsForFile(dtpg, "dangi", parentCLDRFiles.get(0));
            }
            case "chinese": {
                this.addAvailableFormatsWithParents(dtpg, "chinese", parentCLDRFiles);
            }
        }
        return dtpg;
    }

    private void addAvailableFormatsWithParents(DateTimePatternGenerator dtpg, String calendarType, List<CLDRFile> parentCLDRFiles) {
        for (CLDRFile file : parentCLDRFiles) {
            this.addAvailableFormatsForFile(dtpg, calendarType, file);
        }
    }

    private void addAvailableFormatsForFile(DateTimePatternGenerator dtpg, String calendarType, CLDRFile file) {
        String toppath = "//ldml/dates/calendars/calendar[@type=\"" + calendarType + "\"]/dateTimeFormats/availableFormats";
        boolean isRoot = file.getLocaleID().equals("root");
        Iterator<String> it = file.iterator(toppath);
        while (it.hasNext()) {
            String path = it.next();
            int startIndex = path.indexOf(DATE_FORMAT_ITEM_ID_PREFIX);
            if (startIndex < 0 || path.indexOf("[@alt=", startIndex) >= 0) continue;
            int endIndex = path.indexOf("\"]", startIndex += DATE_FORMAT_ITEM_ID_PREFIX.length());
            String skeleton = path.substring(startIndex, endIndex);
            String pattern = file.getWinningValue(path);
            dtpg.addPatternWithSkeleton(pattern, skeleton, !isRoot, this.patternInfo);
        }
    }

    private String stripLiterals(String pattern) {
        int i = 0;
        int patlen = pattern.length();
        StringBuilder stripped = new StringBuilder(patlen);
        boolean inLiteral = false;
        while (i < patlen) {
            char c;
            if ((c = pattern.charAt(i++)) == '\'') {
                inLiteral = !inLiteral;
                continue;
            }
            if (inLiteral) continue;
            stripped.append(c);
        }
        return stripped.toString();
    }

    public String checkValueAgainstSkeleton(String path, String value) {
        XPathParts parts;
        String failure = null;
        String skeleton = null;
        String strippedPattern = null;
        if (path.contains("dateFormatItem")) {
            parts = XPathParts.getFrozenInstance(path);
            skeleton = parts.findAttributeValue("dateFormatItem", "id");
            strippedPattern = this.gen.getSkeleton(value);
        } else if (path.contains("intervalFormatItem")) {
            parts = XPathParts.getFrozenInstance(path);
            skeleton = parts.findAttributeValue("intervalFormatItem", "id");
            strippedPattern = this.stripLiterals(value);
        }
        if (skeleton != null && strippedPattern != null) {
            String calendar;
            if (skeleton.indexOf(72) >= 0 || skeleton.indexOf(107) >= 0) {
                if (strippedPattern.indexOf(104) >= 0 || strippedPattern.indexOf(75) >= 0) {
                    failure = "Skeleton uses 24-hour cycle (H,k) but pattern uses 12-hour (h,K)";
                }
            } else if (skeleton.indexOf(104) >= 0 || skeleton.indexOf(75) >= 0) {
                if (strippedPattern.indexOf(72) >= 0 || strippedPattern.indexOf(107) >= 0) {
                    failure = "Skeleton uses 12-hour cycle (h,K) but pattern uses 24-hour (H,k)";
                }
            } else if (skeleton.indexOf(71) >= 0 && strippedPattern.indexOf(71) < 0 && strippedPattern.indexOf(114) < 0 && strippedPattern.indexOf(85) < 0 && !(calendar = (parts = XPathParts.getFrozenInstance(path)).getAttributeValue(3, "type")).equals("iso8601")) {
                failure = "Skeleton includes 'G' (era) but pattern does not have 'G' (or 'r' or 'U' for chinese/dangi calendars)";
            }
        }
        return failure;
    }

    int getIndex(String s2, String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            if (!s2.equals(strings[i])) continue;
            return i;
        }
        return -1;
    }

    public Collection<String> getRedundants(Collection<String> output) {
        return this.gen.getRedundants(output);
    }

    public Object getFailurePath(Object path) {
        return this.failureMap.get(path);
    }

    public boolean preferred12Hour() {
        return this.isPreferred12Hour;
    }
}

