/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import com.ibm.icu.util.Output;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.CheckLogicalGroupings;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LogicalGrouping;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class LogicalGroupChecker {
    private static final int LIMIT_DISTANCE = 5;
    private final CheckLogicalGroupings checkLogicalGroupings;
    private final String pathToCheck;
    private final String value;
    private final Output<LogicalGrouping.PathType> pathType;
    private final CLDRFile cldrFile;
    private final List<CheckCLDR.CheckStatus> result;
    private final Set<String> paths;
    private final boolean phaseCausesError;
    private final CoverageLevel2 coverageLevel;
    private boolean groupHasOneOrMorePresentRequiredPaths = false;
    private String firstMissingRequiredPath = null;
    private Set<String> presentPaths = null;
    private Set<String> optionalPaths = null;
    private Set<String> missingRequiredPaths = null;
    private CLDRFile.DraftStatus myStatus;

    public LogicalGroupChecker(CheckLogicalGroupings checkLogicalGroupings, String path, String value, List<CheckCLDR.CheckStatus> result) {
        this.checkLogicalGroupings = checkLogicalGroupings;
        this.pathToCheck = path;
        this.value = value;
        this.result = result;
        this.pathType = new Output();
        this.cldrFile = checkLogicalGroupings.getCldrFileToCheck();
        this.paths = LogicalGrouping.getPaths(this.cldrFile, path, this.pathType);
        this.coverageLevel = CoverageLevel2.getInstance(SupplementalDataInfo.getInstance(), this.cldrFile.getLocaleID());
        this.phaseCausesError = CheckLogicalGroupings.PHASES_CAUSE_ERROR.contains((Object)checkLogicalGroupings.getPhase());
    }

    public void run() {
        if (this.paths == null || this.paths.size() < 2) {
            return;
        }
        this.checkEditDistances();
        if (this.checkMissingRequiredPaths()) {
            return;
        }
        if (this.avoidDraftStatusWork()) {
            return;
        }
        this.paths.removeAll(this.optionalPaths);
        this.checkHigherDraftStatus();
    }

    private void checkEditDistances() {
        switch ((LogicalGrouping.PathType)((Object)this.pathType.value)) {
            case COUNT_CASE: 
            case COUNT: 
            case COUNT_CASE_GENDER: {
                TreeSet<String> sorted = new TreeSet<String>(this.paths);
                if (!this.pathToCheck.equals(sorted.iterator().next())) break;
                this.reallyCheckEditDistances(sorted);
                break;
            }
        }
    }

    private void reallyCheckEditDistances(TreeSet<String> sorted) {
        TreeMultiset<String> values = TreeMultiset.create();
        int maxDistance = this.getMaxDistance(sorted, values);
        if (maxDistance >= 5) {
            maxDistance = this.getMaxDistance(this.paths, values);
            this.result.add(new CheckCLDR.CheckStatus().setCause(this.checkLogicalGroupings).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.largerDifferences).setMessage("{0} different characters within {1}; {2}", maxDistance, CheckLogicalGroupings.showInvisibles(values), this.value));
        }
    }

    private int getMaxDistance(Set<String> paths, Multiset<String> values) {
        values.clear();
        HashSet<CheckLogicalGroupings.Fingerprint> fingerprints = new HashSet<CheckLogicalGroupings.Fingerprint>();
        for (String path1 : paths) {
            String valueToCheck;
            String string = valueToCheck = this.pathToCheck.contentEquals(path1) ? this.value : this.cldrFile.getWinningValue(path1);
            if (valueToCheck == null) continue;
            String pathValue = CheckLogicalGroupings.cleanSpaces(valueToCheck);
            values.add(pathValue);
            fingerprints.add(CheckLogicalGroupings.Fingerprint.make(pathValue));
        }
        return CheckLogicalGroupings.Fingerprint.maxDistanceBetween(fingerprints);
    }

    private boolean checkMissingRequiredPaths() {
        this.getPresentAndOptionalPaths();
        this.getMissingRequiredPaths();
        if (this.groupIsIncomplete()) {
            this.handleMissingRequiredPaths();
            return true;
        }
        return false;
    }

    private void getPresentAndOptionalPaths() {
        this.presentPaths = new HashSet<String>();
        this.optionalPaths = new HashSet<String>();
        for (String apath : this.paths) {
            if (this.isHereOrNonRoot(apath)) {
                this.presentPaths.add(apath);
            }
            if (!LogicalGrouping.isOptional(this.cldrFile, apath)) continue;
            this.optionalPaths.add(apath);
        }
    }

    private void getMissingRequiredPaths() {
        this.missingRequiredPaths = new HashSet<String>();
        for (String apath : this.paths) {
            if (this.optionalPaths.contains(apath) || apath.contains("beaufort")) continue;
            if (this.presentPaths.contains(apath)) {
                this.groupHasOneOrMorePresentRequiredPaths = true;
                continue;
            }
            if (this.missingRequiredPaths.isEmpty()) {
                this.firstMissingRequiredPath = apath;
            }
            this.missingRequiredPaths.add(apath);
        }
    }

    private boolean groupIsIncomplete() {
        return this.pathToCheck.equals(this.firstMissingRequiredPath) && (this.groupHasOneOrMorePresentRequiredPaths && this.groupHasTwoOrMoreRequiredPaths() || this.groupHasOneOrMorePresentOptionalPaths());
    }

    private boolean groupHasTwoOrMoreRequiredPaths() {
        return this.paths.size() >= this.optionalPaths.size() + 2;
    }

    private boolean groupHasOneOrMorePresentOptionalPaths() {
        HashSet<String> intersect = new HashSet<String>(this.presentPaths);
        intersect.retainAll(this.optionalPaths);
        return intersect.size() >= 1;
    }

    private void handleMissingRequiredPaths() {
        Set missingCodes = this.missingRequiredPaths.stream().map(x -> this.checkLogicalGroupings.getPathReferenceForMessage((String)x, true)).collect(Collectors.toSet());
        Level cLevel = this.coverageLevel.getLevel(this.pathToCheck);
        CheckCLDR.CheckStatus.Type showError = this.phaseCausesError ? CheckCLDR.CheckStatus.errorType : CheckCLDR.CheckStatus.warningType;
        this.result.add(new CheckCLDR.CheckStatus().setCause(this.checkLogicalGroupings).setMainType(showError).setSubtype(CheckCLDR.CheckStatus.Subtype.incompleteLogicalGroup).setMessage("Incomplete logical group - missing values for: {0}; level={1}", new Object[]{missingCodes.toString(), cLevel}));
    }

    private boolean isHereOrNonRoot(String path) {
        if (this.cldrFile.isHere(path)) {
            return true;
        }
        if (!this.cldrFile.getLocaleID().contains("_")) {
            return false;
        }
        CLDRFile resolvedCldrFile = this.checkLogicalGroupings.getResolvedCldrFileToCheck();
        if (resolvedCldrFile.getStringValue(path) == null) {
            return false;
        }
        String source = resolvedCldrFile.getSourceLocaleID(path, null);
        return !source.equals("root") && !source.equals("code-fallback");
    }

    private boolean avoidDraftStatusWork() {
        String fPath = this.cldrFile.getFullXPath(this.pathToCheck);
        XPathParts parts = XPathParts.getFrozenInstance(fPath);
        this.myStatus = CLDRFile.DraftStatus.forString(parts.findFirstAttributeValue("draft"));
        return this.myStatus.compareTo(CheckLogicalGroupings.MIMIMUM_DRAFT_STATUS) >= 0;
    }

    private void checkHigherDraftStatus() {
        for (String apath : this.paths) {
            XPathParts parts;
            CLDRFile.DraftStatus draftStatus;
            String fPath;
            if (apath.equals(this.pathToCheck) || this.missingRequiredPaths.contains(apath) || (fPath = this.cldrFile.getFullXPath(apath)) == null || (draftStatus = CLDRFile.DraftStatus.forString((parts = XPathParts.getFrozenInstance(fPath)).findFirstAttributeValue("draft"))).compareTo(this.myStatus) <= 0) continue;
            this.addOneHigherStatus(apath, this.myStatus, draftStatus);
            break;
        }
    }

    private void addOneHigherStatus(String apath, CLDRFile.DraftStatus myStatus, CLDRFile.DraftStatus draftStatus) {
        CheckCLDR.CheckStatus.Type showError = this.phaseCausesError ? CheckCLDR.CheckStatus.errorType : CheckCLDR.CheckStatus.warningType;
        this.result.add(new CheckCLDR.CheckStatus().setCause(this.checkLogicalGroupings).setMainType(showError).setSubtype(CheckCLDR.CheckStatus.Subtype.inconsistentDraftStatus).setMessage("This item has draft status={0}, which is lower than the status={1} (for {2}).", myStatus.name(), draftStatus.name(), this.checkLogicalGroupings.getPathReferenceForMessage(apath, true)));
    }
}

