/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.ChainedMap;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.XPathParts;

public class FindAttributeValueDifferences {
    private static final String LAST_ARCHIVE_DIRECTORY = CLDRPaths.ARCHIVE_DIRECTORY;

    public static ChainedMap.M4<String, String, String, Boolean> getActuals(CLDRFile english, ChainedMap.M4<String, String, String, Boolean> result) {
        for (String path : english.fullIterable()) {
            XPathParts parts = XPathParts.getFrozenInstance(path);
            for (int i = 0; i < parts.size(); ++i) {
                String element = parts.getElement(i);
                for (Map.Entry<String, String> av : parts.getAttributes(i).entrySet()) {
                    result.put(element, av.getKey(), av.getValue(), Boolean.TRUE);
                }
            }
        }
        return result;
    }

    public static void main(String[] args) {
        CLDRConfig config = CLDRConfig.getInstance();
        Factory current = config.getCldrFactory();
        Factory last = Factory.make(LAST_ARCHIVE_DIRECTORY + "cldr-" + ToolConstants.LAST_RELEASE_VERSION + "/common/main/", ".*");
        ChainedMap.M4<String, String, String, Boolean> newValues = ChainedMap.of(new TreeMap(), new TreeMap(), new TreeMap(), Boolean.class);
        ChainedMap.M4<String, String, String, Boolean> oldValues = ChainedMap.of(new TreeMap(), new TreeMap(), new TreeMap(), Boolean.class);
        ChainedMap.M3 emptyM3 = ChainedMap.of(new TreeMap(), new TreeMap(), Boolean.class);
        Set<String> modernCldr = StandardCodes.make().getLocaleCoverageLocales(Organization.cldr, EnumSet.of(Level.MODERN));
        for (String locale : Arrays.asList("de")) {
            FindAttributeValueDifferences.getActuals(current.make(locale, false), newValues);
            FindAttributeValueDifferences.getActuals(last.make(locale, false), oldValues);
        }
        TreeSet elements = new TreeSet(newValues.keySet());
        elements.addAll(oldValues.keySet());
        for (String element : elements) {
            ChainedMap.M3 newSubmap = CldrUtility.ifNull(newValues.get(element), emptyM3);
            ChainedMap.M3 oldSubmap = CldrUtility.ifNull(oldValues.get(element), emptyM3);
            TreeSet attributes = new TreeSet(newSubmap.keySet());
            attributes.addAll(oldSubmap.keySet());
            for (String attribute : attributes) {
                Set<String> oldAttValues;
                Set<String> newAttValues = CldrUtility.ifNull(newSubmap.get(attribute), Collections.EMPTY_MAP).keySet();
                if (Objects.equal(newAttValues, oldAttValues = CldrUtility.ifNull(oldSubmap.get(attribute), Collections.EMPTY_MAP).keySet())) continue;
                FindAttributeValueDifferences.showDiff(element, attribute, newAttValues, oldAttValues, "new");
                FindAttributeValueDifferences.showDiff(element, attribute, oldAttValues, newAttValues, "old");
            }
        }
    }

    private static TreeSet<String> showDiff(String element, String attribute, Set<String> newAttValues, Set<String> oldAttValues, String title) {
        TreeSet<String> currentAttributeValues = new TreeSet<String>(newAttValues);
        currentAttributeValues.removeAll(oldAttValues);
        for (String attributeValue : currentAttributeValues) {
            System.out.println(title + "\t" + element + "\t" + attribute + "\t" + attributeValue);
        }
        return currentAttributeValues;
    }
}

