/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Relation;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.unicode.cldr.draft.FileUtilities;

public class MatchStrings {
    static String cldrDataDir = "C:\\cvsdata\\unicode\\cldr\\tools\\java\\org\\unicode\\cldr\\util\\data\\transforms\\";
    Relation<String, Info> letter_correspondances = Relation.of(new TreeMap(), LinkedHashSet.class);
    String english;
    String ipa;
    List<Info> output;
    int highWater = 0;
    List<Info> highWaterList = new ArrayList<Info>();
    private int longestEnglish;
    private int longestIpa;
    List<Info> current = new ArrayList<Info>();

    MatchStrings() throws IOException {
        String line;
        BufferedReader in = FileUtilities.openUTF8Reader(cldrDataDir, "internal_matchIpaRules.txt");
        while ((line = in.readLine()) != null) {
            if (line.length() == 0) continue;
            String[] parts = line.split("\\s+");
            String ipa = parts.length > 1 ? parts[1] : "";
            this.add(parts[0], ipa, parts.length > 2 ? parts[2] : ipa);
        }
        in.close();
    }

    void add(String english, String ipa, String fixedIpa) {
        String key = english.length() == 0 ? "" : english.substring(0, 1);
        this.letter_correspondances.put(key, new Info(english, ipa, fixedIpa));
    }

    int interleaveIPA(String english, String ipa, List<Info> output) {
        this.highWater = 0;
        this.longestEnglish = 0;
        this.longestIpa = 0;
        this.highWaterList.clear();
        this.english = english;
        this.ipa = ipa;
        this.output = output;
        output.clear();
        return this.interleave2(0, 0);
    }

    private int interleave2(int englishPosition, int ipaPosition) {
        Info last;
        int result;
        if (this.highWater < ipaPosition) {
            this.highWaterList.clear();
            this.highWaterList.addAll(this.output);
            this.highWater = this.output.size();
            this.longestEnglish = englishPosition;
            this.longestIpa = ipaPosition;
        }
        if (englishPosition == this.english.length()) {
            if (ipaPosition == this.ipa.length()) {
                return 1;
            }
            return 0;
        }
        String firstLetter = this.english.substring(englishPosition, englishPosition + 1);
        Set<Info> possibilities = this.letter_correspondances.getAll(firstLetter);
        if (possibilities != null && (result = this.checkPossibilities(possibilities, englishPosition, ipaPosition)) != 0) {
            return result;
        }
        possibilities = this.letter_correspondances.getAll("");
        if (possibilities != null && (result = this.checkPossibilities(possibilities, englishPosition, ipaPosition)) != 0) {
            return result;
        }
        Info info = last = this.output.size() == 0 ? null : this.output.get(this.output.size() - 1);
        if (last == null || last.ipa.length() != 0) {
            this.output.add(new Info(firstLetter, "", ""));
            int result2 = this.interleave2(englishPosition + 1, ipaPosition);
            if (result2 == 1) {
                return 1;
            }
            this.output.remove(this.output.size() - 1);
        }
        return 0;
    }

    int checkPossibilities(Collection<Info> possibilities, int englishPosition, int ipaPosition) {
        for (Info englishIpa : possibilities) {
            int matchesUpTo;
            String englishPart = englishIpa.english;
            String ipaPart = englishIpa.ipa;
            if (!this.english.regionMatches(englishPosition, englishPart, 0, englishPart.length()) || (matchesUpTo = this.matchAtIgnoring(ipaPosition, ipaPart)) < 0) continue;
            this.output.add(englishIpa);
            int result = this.interleave2(englishPosition + englishPart.length(), matchesUpTo);
            if (result == 1) {
                return 1;
            }
            this.output.remove(this.output.size() - 1);
        }
        return 0;
    }

    private int matchAtIgnoring(int ipaPosition, String ipaPart) {
        if (ipaPart.length() == 0) {
            return ipaPosition;
        }
        int j = 0;
        for (int i = ipaPosition; i < this.ipa.length(); ++i) {
            char ch2;
            char ch = this.ipa.charAt(i);
            if (ch == '\u02c8' || ch == '\u02cc') continue;
            if (ch != (ch2 = ipaPart.charAt(j++))) {
                return -1;
            }
            if (j < ipaPart.length()) continue;
            return i + 1;
        }
        return -1;
    }

    String fixIPA(String english, String ipa) {
        int result = this.interleaveIPA(english, ipa, this.current);
        if (result == 0) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (Info englishIpa : this.current) {
            buffer.append(englishIpa.fixedIpa);
        }
        return buffer.toString();
    }

    String getTrace() {
        return this.highWaterList.toString() + "\t\t" + this.english.substring(this.longestEnglish) + "\t\u2260\t" + this.ipa.substring(this.longestIpa);
    }

    static class Info {
        String english;
        String ipa;
        String fixedIpa;

        public Info(String english, String ipa, String fixedIpa) {
            this.english = english;
            this.ipa = ipa;
            this.fixedIpa = fixedIpa.equals(ipa) ? ipa : fixedIpa;
        }

        public String toString() {
            return "{" + this.english + "/" + this.ipa + (String)(this.fixedIpa == this.ipa ? "" : "/" + this.fixedIpa) + "}";
        }
    }
}

