/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class DeferredTranscript
implements Supplier<String> {
    private Supplier<String> delegate = null;
    private List<FormatEntry> formats;

    public DeferredTranscript() {
        this.clear();
    }

    public void clear() {
        this.delegate = Suppliers.memoize(new Supplier<String>(){

            @Override
            public String get() {
                return DeferredTranscript.this.formats.stream().map(FormatEntry::format).collect(Collectors.joining("\n"));
            }
        });
        this.formats = new LinkedList<FormatEntry>();
    }

    @Override
    public final String get() {
        return this.delegate.get();
    }

    final DeferredTranscript add(String fmt, Object ... args) {
        this.formats.add(new FormatEntry(fmt, args));
        return this;
    }

    private final class FormatEntry {
        public final CharSequence fmt;
        public final Object[] args;

        public FormatEntry(String fmt, Object[] args) {
            this.fmt = fmt;
            this.args = args;
        }

        public final CharSequence format() {
            if (this.args == null || this.args.length == 0) {
                return this.fmt;
            }
            return String.format(this.fmt.toString(), this.args);
        }
    }
}

