/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.util.Dictionary;
import org.unicode.cldr.util.StateDictionary;
import org.unicode.cldr.util.StateDictionaryBuilder;
import org.unicode.cldr.util.StringByteConverter;

public class DictionaryStringByteConverter
extends StringByteConverter {
    private final Dictionary<String> dictionary;
    private final Dictionary.Matcher<String> matcher;
    private final StringByteConverter byteMaker;
    private final StringBuilder buffer = new StringBuilder();
    private final int maxBytesPerChar;
    private Dictionary.Matcher<CharSequence> backMatcher = null;

    public Dictionary<String> getDictionary() {
        return this.dictionary;
    }

    public DictionaryStringByteConverter(Dictionary<String> dictionary, StringByteConverter byteMaker) {
        this.dictionary = dictionary;
        this.matcher = dictionary.getMatcher();
        this.matcher.setText(this.buffer);
        this.byteMaker = byteMaker;
        int mBytesPerChar = 0;
        Iterator<Map.Entry<CharSequence, String>> m4 = dictionary.getMapping();
        while (m4.hasNext()) {
            Map.Entry<CharSequence, String> entry = m4.next();
            int bytesPerChar = entry.getValue().length() * byteMaker.getMaxBytesPerChar();
            if (mBytesPerChar >= bytesPerChar) continue;
            mBytesPerChar = bytesPerChar;
        }
        this.maxBytesPerChar = mBytesPerChar;
    }

    @Override
    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    @Override
    public int toBytes(char ch, byte[] output, int bytePosition) {
        this.buffer.append(ch);
        return this.toBytes(output, bytePosition, true);
    }

    @Override
    public int toBytes(byte[] output, int bytePosition) {
        return this.toBytes(output, bytePosition, false);
    }

    public int toBytes(byte[] output, int bytePosition, boolean stopOnFinalPartial) {
        block7: while (this.buffer.length() != 0) {
            this.matcher.setText(this.buffer);
            Dictionary.Matcher.Status status = Dictionary.Matcher.Status.NONE;
            int bestEnd = 0;
            String bestValue = null;
            block8: while (true) {
                Dictionary.Matcher.Status tempStatus = this.matcher.next();
                switch (tempStatus) {
                    case NONE: {
                        break block8;
                    }
                    case PARTIAL: {
                        if (!stopOnFinalPartial || this.matcher.getMatchEnd() != this.buffer.length()) continue block8;
                        this.matcher.nextUniquePartial();
                        return bytePosition;
                    }
                    default: {
                        status = tempStatus;
                        bestEnd = this.matcher.getMatchEnd();
                        bestValue = this.matcher.getMatchValue();
                        continue block8;
                    }
                }
                break;
            }
            switch (status) {
                case MATCH: {
                    bytePosition = this.byteMaker.toBytes(bestValue, output, bytePosition);
                    this.buffer.delete(0, bestEnd);
                    continue block7;
                }
            }
            bytePosition = this.byteMaker.toBytes(this.buffer.charAt(0), output, bytePosition);
            this.buffer.delete(0, 1);
        }
        return bytePosition;
    }

    @Override
    public Appendable fromBytes(byte[] input, int byteStart, int byteLength, Appendable result) {
        StringBuffer internal = new StringBuffer();
        this.byteMaker.fromBytes(input, byteStart, byteLength, internal);
        if (this.backMatcher == null) {
            TreeMap<CharSequence, CharSequence> back = new TreeMap<CharSequence, CharSequence>(Dictionary.CHAR_SEQUENCE_COMPARATOR);
            Iterator<Map.Entry<CharSequence, String>> m4 = this.dictionary.getMapping();
            while (m4.hasNext()) {
                Map.Entry<CharSequence, String> entry = m4.next();
                if (entry.getValue().length() == 0 || back.containsKey(entry.getValue())) continue;
                back.put(entry.getValue(), entry.getKey());
            }
            this.backMatcher = ((StateDictionary)new StateDictionaryBuilder().make(back)).getMatcher();
        }
        this.backMatcher.setText(internal).convert(result);
        return result;
    }
}

