/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.unicode.cldr.util.FileReaders;
import org.unicode.cldr.util.With;

public class StringIterables {
    public static Iterable<String> in(Class<?> class1, String file) {
        return With.in(new With.SimpleIterator[]{new FileLines(FileReaders.openFile(class1, file, StandardCharsets.UTF_8))});
    }

    public static Iterable<String> in(Class<?> class1, String file, Charset charset) {
        return With.in(new With.SimpleIterator[]{new FileLines(FileReaders.openFile(class1, file, charset))});
    }

    public static Iterable<String> in(String directory, String file) {
        return With.in(new With.SimpleIterator[]{new FileLines(FileReaders.openFile(directory, file, StandardCharsets.UTF_8))});
    }

    public static Iterable<String> in(BufferedReader reader) {
        return With.in(new With.SimpleIterator[]{new FileLines(reader)});
    }

    public static Iterable<String> in(String directory, String file, Charset charset) {
        return With.in(new With.SimpleIterator[]{new FileLines(FileReaders.openFile(directory, file, charset))});
    }

    private static class FileLines
    implements With.SimpleIterator<String> {
        private BufferedReader input;

        public FileLines(BufferedReader input) {
            this.input = input;
        }

        @Override
        public String next() {
            try {
                String result = this.input.readLine();
                if (result == null) {
                    this.input.close();
                }
                return result;
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException(e);
            }
        }
    }
}

