/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.MeasureFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Measure;
import com.ibm.icu.util.MeasureUnit;
import com.ibm.icu.util.ULocale;

public final class Timer {
    private static final double NANOS_PER_SECOND = 1.0E9;
    private long startTime;
    private long duration;
    private static DecimalFormat nf = (DecimalFormat)NumberFormat.getNumberInstance(ULocale.ENGLISH);
    private static DecimalFormat pf = (DecimalFormat)NumberFormat.getPercentInstance(ULocale.ENGLISH);

    public Timer() {
        this.start();
    }

    public void start() {
        this.startTime = System.nanoTime();
        this.duration = Long.MIN_VALUE;
    }

    public long getDuration() {
        if (this.duration == Long.MIN_VALUE) {
            this.duration = System.nanoTime() - this.startTime;
        }
        return this.duration;
    }

    public long getNanoseconds() {
        return this.getDuration();
    }

    public double getSeconds() {
        return (double)this.getDuration() / 1.0E9;
    }

    public long stop() {
        return this.getDuration();
    }

    public String toString() {
        return nf.format((double)this.getDuration() / 1.0E9) + "s";
    }

    public String toMeasureString() {
        double seconds = this.getSeconds();
        double minutes = Math.floorDiv((int)seconds, 60);
        return MeasureFormat.getInstance(ULocale.ENGLISH, MeasureFormat.FormatWidth.SHORT).formatMeasures(new Measure(seconds -= minutes * 60.0, MeasureUnit.SECOND), new Measure(minutes, MeasureUnit.MINUTE));
    }

    public String toString(Timer other) {
        return this.toString(1L, other.getDuration());
    }

    public String toString(long iterations) {
        return nf.format((double)this.getDuration() / (1.0E9 * (double)iterations)) + "s";
    }

    public String toString(long iterations, long other) {
        return this.toString(iterations) + "\t(" + pf.format((double)this.getDuration() / (double)other - 1.0) + ")";
    }

    static {
        nf.setMaximumSignificantDigits(3);
        pf.setMaximumFractionDigits(1);
        pf.setPositivePrefix("+");
    }
}

