/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class CharEncoder {
    private boolean verifyRoundtrip;
    private boolean justCheck;
    private CharsetEncoder encoder;
    private CharsetDecoder decoder;
    private char[] chars = new char[2];
    private char[] returnChars = new char[2];
    private CharBuffer charBuffer = CharBuffer.wrap(this.chars);
    private ByteBuffer byteBuffer = ByteBuffer.allocate(5);
    private CharBuffer returnCharBuffer = CharBuffer.wrap(this.returnChars);

    public CharEncoder(Charset charset, boolean verifyRoundtrip, boolean justCheck) {
        this.verifyRoundtrip = verifyRoundtrip;
        this.justCheck = justCheck;
        this.encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        this.decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    public boolean isVerifyRoundtrip() {
        return this.verifyRoundtrip;
    }

    public int getValue(int codepoint, byte[] destination, int offset) {
        try {
            int len = Character.toChars(codepoint, this.chars, 0);
            this.charBuffer.limit(len);
            this.charBuffer.position(0);
            this.byteBuffer.clear();
            CoderResult encodeResult = this.encoder.encode(this.charBuffer, this.byteBuffer, true);
            if (encodeResult.isError()) {
                return -1;
            }
            if (this.verifyRoundtrip) {
                this.byteBuffer.flip();
                this.returnCharBuffer.clear();
                CoderResult decodeResult = this.decoder.decode(this.byteBuffer, this.returnCharBuffer, true);
                if (decodeResult.isError()) {
                    return -1;
                }
                int len2 = this.returnCharBuffer.position();
                if (len != len2) {
                    return -1;
                }
                if (this.chars[0] != this.returnChars[0]) {
                    return -1;
                }
                if (len > 1 && this.chars[1] != this.returnChars[1]) {
                    return -1;
                }
            }
            if (this.justCheck) {
                return 1;
            }
            this.byteBuffer.flip();
            int byteLen = this.byteBuffer.limit();
            this.byteBuffer.get(destination, offset, byteLen);
            return byteLen;
        }
        catch (Exception e) {
            if (e instanceof BufferUnderflowException) {
                throw (BufferUnderflowException)e;
            }
            return -1;
        }
    }
}

