/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu.dev.test;

public class UTF16Util {
    static final int suppOffset = 56613888;
    public static final int SUPPLEMENTARY_MIN_VALUE = 65536;
    public static final int LEAD_SURROGATE_MAX_VALUE = 56319;
    public static final int LEAD_SURROGATE_MIN_VALUE = 55296;
    public static final int TRAIL_SURROGATE_MIN_VALUE = 56320;
    public static final int TRAIL_SURROGATE_MAX_VALUE = 57343;
    private static final int LEAD_SURROGATE_SHIFT_ = 10;
    private static final int SURROGATE_OFFSET_ = -56613888;

    public static final int nextCodePoint(String s2, int i) {
        char ch2;
        int ch = s2.charAt(i);
        if (55296 <= ch && ch <= 56319 && ++i < s2.length() && '\udc00' <= (ch2 = s2.charAt(i)) && ch2 <= '\udfff') {
            ch = (ch << 10) + ch2 - 56613888;
        }
        return ch;
    }

    public static final int prevCodePoint(String s2, int i) {
        char ch2;
        int ch;
        if (56320 <= (ch = s2.charAt(--i)) && ch <= 57343 && --i >= 0 && '\ud800' <= (ch2 = s2.charAt(i)) && ch2 <= '\udbff') {
            ch = (ch2 << 10) + ch - 56613888;
        }
        return ch;
    }

    public static final int nextCodePoint(StringBuffer s2, int i) {
        char ch2;
        int ch = s2.charAt(i);
        if (55296 <= ch && ch <= 56319 && ++i < s2.length() && '\udc00' <= (ch2 = s2.charAt(i)) && ch2 <= '\udfff') {
            ch = (ch << 10) + ch2 - 56613888;
        }
        return ch;
    }

    public static final int prevCodePoint(StringBuffer s2, int i) {
        char ch2;
        int ch;
        if (56320 <= (ch = s2.charAt(--i)) && ch <= 57343 && --i >= 0 && '\ud800' <= (ch2 = s2.charAt(i)) && ch2 <= '\udbff') {
            ch = (ch2 << 10) + ch - 56613888;
        }
        return ch;
    }

    public static final int codePointLength(int c) {
        return c <= 65535 ? 1 : 2;
    }

    public static final void appendCodePoint(StringBuffer buffer, int ch) {
        if (ch <= 65535) {
            buffer.append((char)ch);
        } else {
            buffer.append((char)(55232 + (ch >> 10)));
            buffer.append((char)(56320 + (ch & 0x3FF)));
        }
    }

    public static final void insertCodePoint(StringBuffer buffer, int i, int ch) {
        if (ch <= 65535) {
            buffer.insert(i, (char)ch);
        } else {
            buffer.insert(i, (char)(55232 + (ch >> 10))).insert(i + 1, (char)(56320 + (ch & 0x3FF)));
        }
    }

    public static final int setCodePointAt(StringBuffer buffer, int i, int ch) {
        int cp = UTF16Util.nextCodePoint(buffer, i);
        if (ch <= 65535 && cp <= 65535) {
            buffer.setCharAt(i, (char)ch);
            return 0;
        }
        if (ch > 65535 && cp > 65535) {
            buffer.setCharAt(i, (char)(55232 + (ch >> 10)));
            buffer.setCharAt(i + 1, (char)(56320 + (ch & 0x3FF)));
            return 0;
        }
        if (ch <= 65535 && cp > 65535) {
            buffer.setCharAt(i, (char)ch);
            buffer.deleteCharAt(i + 1);
            return -1;
        }
        buffer.setCharAt(i, (char)(55232 + (ch >> 10)));
        buffer.insert(i + 1, (char)(56320 + (ch & 0x3FF)));
        return 1;
    }

    public static final int countCodePoint(String source) {
        int result = 0;
        boolean hadLeadSurrogate = false;
        for (int i = 0; i < source.length(); ++i) {
            char ch = source.charAt(i);
            if (hadLeadSurrogate && '\udc00' <= ch && ch <= '\udfff') {
                hadLeadSurrogate = false;
                continue;
            }
            hadLeadSurrogate = '\ud800' <= ch && ch <= '\udbff';
            ++result;
        }
        return result;
    }

    public static final int countCodePoint(StringBuffer source) {
        int result = 0;
        boolean hadLeadSurrogate = false;
        for (int i = 0; i < source.length(); ++i) {
            char ch = source.charAt(i);
            if (hadLeadSurrogate && '\udc00' <= ch && ch <= '\udfff') {
                hadLeadSurrogate = false;
                continue;
            }
            hadLeadSurrogate = '\ud800' <= ch && ch <= '\udbff';
            ++result;
        }
        return result;
    }

    public static int getCharCount(int char32) {
        if (char32 < 65536) {
            return 1;
        }
        return 2;
    }

    public static boolean isSurrogate(char char16) {
        return '\ud800' <= char16 && char16 <= '\udfff';
    }

    public static boolean isTrailSurrogate(char char16) {
        return '\udc00' <= char16 && char16 <= '\udfff';
    }

    public static boolean isLeadSurrogate(char char16) {
        return '\ud800' <= char16 && char16 <= '\udbff';
    }

    public static int charAt(char[] source, int start, int limit, int offset16) {
        if ((offset16 += start) < start || offset16 >= limit) {
            throw new ArrayIndexOutOfBoundsException(offset16);
        }
        char single = source[offset16];
        if (!UTF16Util.isSurrogate(single)) {
            return single;
        }
        if (single <= '\udbff') {
            if (++offset16 >= limit) {
                return single;
            }
            char trail = source[offset16];
            if (UTF16Util.isTrailSurrogate(trail)) {
                return UTF16Util.getRawSupplementary(single, trail);
            }
        } else {
            char lead;
            if (offset16 == start) {
                return single;
            }
            if (UTF16Util.isLeadSurrogate(lead = source[--offset16])) {
                return UTF16Util.getRawSupplementary(lead, single);
            }
        }
        return single;
    }

    public static int getRawSupplementary(char lead, char trail) {
        return (lead << 10) + trail + -56613888;
    }
}

