/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu.dev.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnicodeKnownIssues {
    private Map<String, List<String>> knownIssues = new ConcurrentHashMap<String, List<String>>();
    public static final int KNOWN_ISSUES_CURTAILMENT = 2;
    private boolean allKnownIssues;
    public static final String UNICODE_JIRA_BROWSE = "https://unicode-org.atlassian.net/browse/";
    static final Pattern ICU_TICKET_PATTERN = Pattern.compile("(?i)(?:icu-)?(\\d+)");
    static final Pattern CLDR_TICKET_PATTERN = Pattern.compile("(?i)cldr(?:bug:|-)?(\\d+)");
    static final Pattern UNICODE_JIRA_PATTERN = Pattern.compile("(CLDR|ICU)-(\\d+)");

    public void clear() {
        this.knownIssues.clear();
    }

    public UnicodeKnownIssues(boolean allKnownIssues) {
        this.allKnownIssues = allKnownIssues;
    }

    public void logKnownIssue(String path, String ticket, String comment) {
        List<String> lines;
        StringBuilder descBuf = new StringBuilder(path);
        if (comment != null && comment.length() > 0) {
            descBuf.append(" (" + comment + ")");
        }
        String description = descBuf.toString();
        Object ticketLink = "Unknown Ticket";
        if (ticket != null && ticket.length() > 0) {
            Matcher matcher = ICU_TICKET_PATTERN.matcher(ticket);
            if (matcher.matches()) {
                ticketLink = "ICU-" + matcher.group(1);
            } else {
                matcher = CLDR_TICKET_PATTERN.matcher(ticket);
                if (matcher.matches()) {
                    ticketLink = "CLDR-" + matcher.group(1);
                }
            }
        }
        if ((lines = this.knownIssues.get(ticketLink)) == null) {
            lines = new ArrayList<String>();
            this.knownIssues.put((String)ticketLink, lines);
        }
        if (!lines.contains(description)) {
            lines.add(description);
        }
    }

    public boolean printKnownIssues(Consumer<String> logFn) {
        if (this.knownIssues.isEmpty()) {
            return false;
        }
        boolean didCurtail = false;
        logFn.accept("\n " + this.knownIssues.size() + " Known Issues:");
        for (Map.Entry<String, List<String>> entry : this.knownIssues.entrySet()) {
            String ticketLink = entry.getKey();
            if (UNICODE_JIRA_PATTERN.matcher(ticketLink) != null) {
                logFn.accept(ticketLink + " <https://unicode-org.atlassian.net/browse/" + ticketLink + ">");
            } else {
                logFn.accept("<" + ticketLink + ">");
            }
            List<String> entries = entry.getValue();
            int issuesToShow = entries.size();
            if (!this.allKnownIssues && issuesToShow > 2) {
                issuesToShow = 1;
            }
            for (int i = 0; i < issuesToShow; ++i) {
                logFn.accept("  - " + entries.get(i));
            }
            if (entries.size() <= issuesToShow) continue;
            didCurtail = true;
            logFn.accept("  ... and " + (entries.size() - issuesToShow) + " more");
        }
        return didCurtail;
    }
}

