/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleHtmlParser;
import org.unicode.cldr.util.TransliteratorUtilities;

public class HelpMessages {
    private static final Matcher CLEANUP_BOOKMARK = PatternCache.get("[^a-zA-Z0-9]").matcher("");
    private static final MessageFormat DEFAULT_HEADER_PATTERN = new MessageFormat("<p>{0}</p>\n");
    private static final Matcher HEADER_HTML = PatternCache.get("<h[0-9]>(.*)</h[0-9]>").matcher("");
    List<Matcher> keys = new ArrayList<Matcher>();
    List<String> values = new ArrayList<String>();
    StringBuilder[] currentColumn = new StringBuilder[2];
    int column = 0;
    private static HelpMessages helpMessages;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HelpMessages(String filename) {
        this.currentColumn[0] = new StringBuilder();
        this.currentColumn[1] = new StringBuilder();
        try {
            BufferedReader in = CldrUtility.getUTF8Data(filename);
            int tableCount = 0;
            boolean inContent = false;
            SimpleHtmlParser simple = new SimpleHtmlParser().setReader(in);
            StringBuilder result = new StringBuilder();
            boolean hadPop = false;
            block8: while (true) {
                SimpleHtmlParser.Type x = simple.next(result);
                switch (x) {
                    case ELEMENT: {
                        if (SimpleHtmlParser.equals("table", result)) {
                            if (hadPop) {
                                --tableCount;
                                break;
                            }
                            ++tableCount;
                            break;
                        }
                        if (tableCount != 1) break;
                        if (SimpleHtmlParser.equals("tr", result)) {
                            if (hadPop) {
                                this.addHelpMessages();
                            }
                            this.column = 0;
                            break;
                        }
                        if (!SimpleHtmlParser.equals("td", result)) break;
                        if (hadPop) {
                            inContent = false;
                            ++this.column;
                            break;
                        }
                        inContent = true;
                        continue block8;
                    }
                    case ELEMENT_POP: {
                        hadPop = true;
                        break;
                    }
                    case ELEMENT_END: {
                        hadPop = false;
                        break;
                    }
                    case DONE: {
                        break block8;
                    }
                }
                if (!inContent) continue;
                SimpleHtmlParser.writeResult(x, result, this.currentColumn[this.column]);
            }
            in.close();
            return;
        }
        catch (IOException e) {
            System.err.println("Can't initialize help text");
        }
    }

    public String find(String key) {
        return this.find(key, DEFAULT_HEADER_PATTERN);
    }

    public String find(String key, MessageFormat headerPattern) {
        StringBuilder header = new StringBuilder();
        StringBuilder result = new StringBuilder();
        int keyCount = 0;
        for (int i = 0; i < this.keys.size(); ++i) {
            if (!this.keys.get(i).reset(key).matches()) continue;
            if (result.length() != 0) {
                result.append("\n");
            }
            String value = this.values.get(i);
            if (headerPattern != null) {
                HEADER_HTML.reset(value);
                int lastEnd = 0;
                StringBuilder newValue = new StringBuilder();
                while (HEADER_HTML.find()) {
                    String contents = HEADER_HTML.group(1);
                    if (contents.contains("<")) continue;
                    String bookmark = "HM_" + CLEANUP_BOOKMARK.reset(contents).replaceAll("_");
                    ++keyCount;
                    if (header.length() > 0) {
                        header.append(" | ");
                    }
                    header.append("<a href='#").append(bookmark).append("'>").append(contents).append("</a>");
                    newValue.append(value.substring(lastEnd, HEADER_HTML.start(1)));
                    newValue.append("<a name='").append(bookmark).append("'>").append(contents).append("</a>");
                    lastEnd = HEADER_HTML.end(1);
                }
                newValue.append(value.substring(lastEnd));
                value = newValue.toString();
            }
            result.append(value);
        }
        if (result.length() != 0) {
            if (keyCount > 1) {
                result.insert(0, headerPattern.format(new Object[]{header.toString()}));
            }
            return result.toString();
        }
        return null;
    }

    private void addHelpMessages() {
        if (this.column == 2) {
            try {
                String key = this.currentColumn[0].substring(1, this.currentColumn[0].length() - 2).trim();
                String value = this.currentColumn[1].substring(1, this.currentColumn[1].length() - 2).trim();
                Matcher m4 = Pattern.compile(TransliteratorUtilities.fromHTML.transliterate(key), 4).matcher("");
                this.keys.add(m4);
                this.values.add(value);
            }
            catch (RuntimeException e) {
                System.err.println("Help file has illegal regex: " + String.valueOf(this.currentColumn[0]));
            }
        }
        this.currentColumn[0].setLength(0);
        this.currentColumn[1].setLength(0);
        this.column = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getChartMessages(String xpath) {
        Class<HelpMessages> clazz = HelpMessages.class;
        synchronized (HelpMessages.class) {
            if (helpMessages == null) {
                helpMessages = new HelpMessages("chart_messages.html");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return helpMessages.find(xpath);
        }
    }

    static enum Status {
        BASE,
        BEFORE_CELL,
        IN_CELL,
        IN_INSIDE_TABLE;

    }
}

