/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.XPathParts;

public class ExtractCollationRules {
    Map<String, String> type_rules = new TreeMap<String, String>();
    StringBuffer rules = new StringBuffer();
    static StringBuffer quoteOperandBuffer = new StringBuffer();
    static UnicodeSet needsQuoting = null;
    static UnicodeSet needsUnicodeForm = null;

    public ExtractCollationRules set(CLDRFile file) {
        this.type_rules.clear();
        String lastType = "";
        this.rules.setLength(0);
        String context = null;
        Iterator<String> it = file.iterator("//ldml/collations", file.getComparator());
        block9: while (it.hasNext()) {
            String mainType;
            String path = it.next();
            String value = file.getStringValue(path);
            XPathParts parts = XPathParts.getFrozenInstance(path);
            String type = parts.findAttributeValue("collation", "type");
            if (!type.equals(lastType)) {
                lastType = type;
                this.type_rules.put(lastType, this.rules.toString());
                this.rules.setLength(0);
            }
            if ((mainType = parts.getElement(3)).equals("settings")) {
                this.writeSettings(parts.getAttributes(3), this.rules);
                continue;
            }
            if (mainType.equals("rules")) {
                String ruleType = parts.getElement(4);
                char c = ruleType.charAt(0);
                if (c == 'x') {
                    ruleType = parts.getElement(5);
                    c = ruleType.charAt(0);
                }
                boolean isMultiple = ruleType.length() > 1 && ruleType.charAt(1) == 'c';
                String lastContext = context;
                context = null;
                switch (c) {
                    case 'r': {
                        this.appendOrdering("&", null, value, false, true);
                        continue block9;
                    }
                    case 'p': {
                        this.appendOrdering("<", lastContext, value, isMultiple, true);
                        continue block9;
                    }
                    case 's': {
                        this.appendOrdering("<<", lastContext, value, isMultiple, true);
                        continue block9;
                    }
                    case 't': {
                        this.appendOrdering("<<<", lastContext, value, isMultiple, false);
                        continue block9;
                    }
                    case 'i': {
                        this.appendOrdering("=", lastContext, value, isMultiple, false);
                        continue block9;
                    }
                    case 'c': {
                        context = value;
                        continue block9;
                    }
                    case 'e': {
                        this.appendOrdering("/", null, value, false, false);
                        continue block9;
                    }
                }
                System.out.println("Couldn't handle: " + path + "\t" + value);
                continue;
            }
            System.out.println("Couldn't handle: " + path + "\t" + value);
        }
        this.type_rules.put(lastType, this.rules.toString());
        return this;
    }

    private void appendOrdering(String relation, String context, String valueAfter, boolean isMultiple, boolean lineBreakBefore) {
        if (isMultiple) {
            int cp;
            for (int i = 0; i < valueAfter.length(); i += UTF16.getCharCount(cp)) {
                cp = UTF16.charAt(valueAfter, i);
                if (lineBreakBefore) {
                    this.rules.append("\n");
                } else {
                    this.rules.append(' ');
                }
                this.rules.append(relation);
                if (context != null) {
                    this.rules.append(' ').append(ExtractCollationRules.quote(context));
                }
                this.rules.append(' ').append(ExtractCollationRules.quote(UTF16.valueOf(cp)));
            }
        } else {
            if (lineBreakBefore) {
                this.rules.append("\n");
            } else {
                this.rules.append(' ');
            }
            this.rules.append(relation);
            if (context != null) {
                this.rules.append(' ').append(ExtractCollationRules.quote(context));
            }
            this.rules.append(' ').append(ExtractCollationRules.quote(valueAfter));
        }
    }

    private void writeSettings(Map<String, String> attributes, StringBuffer results) {
        for (String attribute : attributes.keySet()) {
            String value = attributes.get(attribute);
            results.append("[" + attribute + " " + value + "]\n");
        }
    }

    public Iterator<String> iterator() {
        return this.type_rules.keySet().iterator();
    }

    public String getRules(Object key) {
        return this.type_rules.get(key);
    }

    static final String quote(String s2) {
        int cp;
        if (needsQuoting == null) {
            needsQuoting = new UnicodeSet("[[:whitespace:][:c:][:z:][:ascii:]-[a-zA-Z0-9]]");
            needsUnicodeForm = new UnicodeSet("[\\u000d\\u000a[:zl:][:zp:]]");
        }
        s2 = Normalizer.compose(s2, false);
        quoteOperandBuffer.setLength(0);
        boolean noQuotes = true;
        boolean inQuote = false;
        for (int i = 0; i < s2.length(); i += UTF16.getCharCount(cp)) {
            cp = UTF16.charAt(s2, i);
            if (!needsQuoting.contains(cp)) {
                if (inQuote) {
                    quoteOperandBuffer.append('\'');
                    inQuote = false;
                }
                quoteOperandBuffer.append(UTF16.valueOf(cp));
                continue;
            }
            noQuotes = false;
            if (cp == 39) {
                quoteOperandBuffer.append("''");
                continue;
            }
            if (!inQuote) {
                quoteOperandBuffer.append('\'');
                inQuote = true;
            }
            if (!needsUnicodeForm.contains(cp)) {
                quoteOperandBuffer.append(UTF16.valueOf(cp));
                continue;
            }
            if (cp > 65535) {
                quoteOperandBuffer.append("\\U").append(ExtractCollationRules.hex(cp, 8));
                continue;
            }
            if (cp <= 32 || cp > 126) {
                quoteOperandBuffer.append("\\u").append(ExtractCollationRules.hex(cp, 4));
                continue;
            }
            quoteOperandBuffer.append(UTF16.valueOf(cp));
        }
        if (inQuote) {
            quoteOperandBuffer.append('\'');
        }
        if (noQuotes) {
            return s2;
        }
        return quoteOperandBuffer.toString();
    }

    public static String hex(long i, int places) {
        Object result;
        boolean negative;
        if (i == Long.MIN_VALUE) {
            return "-8000000000000000";
        }
        boolean bl = negative = i < 0L;
        if (negative) {
            i = -i;
        }
        if (((String)(result = Long.toString(i, 16).toUpperCase())).length() < places) {
            result = "0000000000000000".substring(((String)result).length(), places) + (String)result;
        }
        if (negative) {
            return "-" + (String)result;
        }
        return result;
    }
}

