/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRLocale;

public class LocaleSet {
    private final Set<CLDRLocale> set = new TreeSet<CLDRLocale>();
    private boolean isAllLocales = false;

    public LocaleSet() {
    }

    public LocaleSet(boolean isAllLocales) {
        this.isAllLocales = isAllLocales;
    }

    public LocaleSet(Set<String> localeNameSet) {
        for (String s2 : localeNameSet) {
            this.set.add(CLDRLocale.getInstance(s2));
        }
    }

    public void add(CLDRLocale locale) {
        this.set.add(locale);
    }

    public void addAll(Set<CLDRLocale> localeListSet) {
        this.set.addAll(localeListSet);
    }

    public boolean contains(CLDRLocale locale) {
        return this.isAllLocales || this.set.contains(locale);
    }

    public boolean containsLocaleOrParent(CLDRLocale locale) {
        if (this.isAllLocales || this.set.contains(locale)) {
            return true;
        }
        CLDRLocale parent = locale.getParent();
        return parent != null && this.set.contains(parent);
    }

    public String toString() {
        if (this.isAllLocales) {
            return "*";
        }
        TreeSet<String> strSet = new TreeSet<String>();
        for (CLDRLocale loc : this.set) {
            strSet.add(loc.getBaseName());
        }
        return String.join((CharSequence)" ", strSet);
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public boolean isAllLocales() {
        return this.isAllLocales;
    }

    public CLDRLocale firstElement() {
        return this.set.iterator().next();
    }

    public Set<CLDRLocale> getSet() {
        if (this.isAllLocales) {
            throw new IllegalArgumentException("Do not call getSet if isAllLocales");
        }
        return this.set;
    }

    public boolean intersectionNonEmpty(LocaleSet otherSet) {
        if (this.isEmpty() || otherSet.isEmpty()) {
            return false;
        }
        if (this.isAllLocales || otherSet.isAllLocales) {
            return true;
        }
        return !Sets.intersection(this.getSet(), otherSet.getSet()).isEmpty();
    }

    public LocaleSet combineRegionalVariants() {
        if (this.isAllLocales || this.isEmpty()) {
            return this;
        }
        TreeSet<String> languageSet = new TreeSet<String>();
        for (CLDRLocale locale : this.getSet()) {
            languageSet.add(locale.getLanguage());
        }
        return new LocaleSet(languageSet);
    }
}

