/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.concurrent.ConcurrentHashMap;
import org.unicode.cldr.util.XPathParts;

public class PathStarrer {
    public static final String PERCENT_A_PATTERN = "%A";
    public static final String SIMPLE_STAR_PATTERN = "*";
    private static final String STAR_PATTERN = "([^\"]*+)";
    private static final ConcurrentHashMap<String, String> STAR_CACHE = new ConcurrentHashMap();

    public static String get(String path) {
        return STAR_CACHE.computeIfAbsent(path, x -> {
            XPathParts parts = XPathParts.getFrozenInstance(x).cloneAsThawed();
            for (int i = 0; i < parts.size(); ++i) {
                for (String key : parts.getAttributeKeys(i)) {
                    parts.setAttribute(i, key, STAR_PATTERN);
                }
            }
            return parts.toString();
        });
    }

    public static String getWithPattern(String path, String pattern) {
        return PathStarrer.get(path).replace(STAR_PATTERN, pattern);
    }
}

