/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.PrintWriter;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.SupplementalDataInfo;

public class PluralSnapshot
implements Comparable<PluralSnapshot> {
    static final int LEN = 128;
    static Set<Double> zeroOne = new TreeSet<Double>();
    public final int count;
    public final int count01;
    EnumSet<Plurals> coveredBy01 = EnumSet.noneOf(Plurals.class);
    EnumSet<Plurals> not01 = EnumSet.noneOf(Plurals.class);
    Plurals[] plurals = new Plurals[128];
    private BitSet pluralsTransitionAt;
    static NumberFormat nf;
    private static final EnumMap<SupplementalDataInfo.PluralType, EnumMap<Integral, SnapshotInfo>> SINGLETONS;
    private EnumSet<Plurals> found;

    public static SnapshotInfo getInstance(SupplementalDataInfo.PluralType pluralType, Integral integral) {
        EnumMap<Integral, SnapshotInfo> temp = SINGLETONS.get((Object)pluralType);
        SnapshotInfo result = temp.get((Object)integral);
        if (result == null) {
            result = new SnapshotInfo(pluralType, integral);
            temp.put(integral, result);
        }
        return result;
    }

    PluralSnapshot(PluralRules pluralRules, Integral integral, BitSet pluralsTransitionAt) {
        this.pluralsTransitionAt = pluralsTransitionAt;
        double offset = integral == Integral.integer ? 0.0 : 0.5;
        this.found = EnumSet.noneOf(Plurals.class);
        this.not01 = EnumSet.noneOf(Plurals.class);
        pluralsTransitionAt.set(0);
        for (int i = 0; i < this.plurals.length; ++i) {
            Plurals plural;
            double probe = (double)i + offset;
            this.plurals[i] = plural = Plurals.valueOf(pluralRules.select(probe));
            this.found.add(plural);
            if (probe != 0.0 && probe != 1.0) {
                this.not01.add(plural);
            }
            if (i <= 0 || plural == this.plurals[i - 1]) continue;
            pluralsTransitionAt.set(i);
        }
        this.coveredBy01.addAll(this.found);
        this.coveredBy01.removeAll(this.not01);
        this.count = this.found.size();
        this.count01 = 2 + this.not01.size();
    }

    @Override
    public int compareTo(PluralSnapshot other) {
        int diff = this.count - other.count;
        if (diff != 0) {
            return diff;
        }
        diff = UnicodeSet.compare(this.found, other.found);
        if (diff != 0) {
            return diff;
        }
        Iterator it = other.not01.iterator();
        for (Plurals p : this.not01) {
            Plurals otherOne;
            diff = p.compareTo(otherOne = (Plurals)((Object)it.next()));
            if (diff == 0) continue;
            return diff;
        }
        for (int i = 0; i < this.plurals.length; ++i) {
            diff = this.plurals[i].compareTo(other.plurals[i]);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public boolean equals(Object other) {
        return this.compareTo((PluralSnapshot)other) == 0;
    }

    public int hashCode() {
        return this.count;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Plurals: 0, 1, ").append(Joiner.on(", ").join(this.not01));
        if (this.coveredBy01.size() != 0) {
            result.append("\nCovered by {0,1}:\t").append(this.coveredBy01);
        }
        result.append("\nInt:\t");
        PluralSnapshot.appendItems(result, this.plurals, 0.0);
        return result.toString();
    }

    public String toHtmlString() {
        StringBuilder result = new StringBuilder();
        result.append("<tr>");
        Plurals lastItem = null;
        int colSpan = 0;
        int i = this.pluralsTransitionAt.nextSetBit(0);
        while (i >= 0) {
            Plurals item = this.plurals[i];
            if (item == lastItem) {
                ++colSpan;
            } else {
                if (lastItem != null) {
                    this.appendCell(result, colSpan, lastItem);
                    colSpan = 0;
                }
                ++colSpan;
                lastItem = item;
            }
            i = this.pluralsTransitionAt.nextSetBit(i + 1);
        }
        this.appendCell(result, colSpan, lastItem);
        result.append("</tr>");
        return result.toString();
    }

    private void appendCell(StringBuilder result, int colSpan, Plurals item) {
        result.append("<td class='").append(item.abbreviated());
        if (this.coveredBy01.contains((Object)item)) {
            result.append(" c01");
        }
        result.append("'");
        if (colSpan != 1) {
            result.append(" colSpan='" + colSpan + "'");
        }
        result.append(" title='").append(item.toString()).append("'>").append(item.abbreviated()).append("</td>");
    }

    private static <T> void appendItems(StringBuilder result, T[] plurals3, double offset) {
        int start = 0;
        result.append(plurals3[0]).append("=").append(nf.format((double)start + offset));
        for (int i = 1; i < plurals3.length; ++i) {
            if (plurals3[i].equals(plurals3[i - 1])) continue;
            if (i - 1 != start) {
                result.append("-").append(nf.format((double)(i - 1) + offset));
            }
            result.append("; ").append(plurals3[i]).append("=").append(nf.format((double)i + offset));
            start = i;
        }
        if (plurals3.length - 1 != start) {
            result.append("-").append(nf.format((double)(plurals3.length - 1) + offset));
        }
    }

    public static String getDefaultStyles() {
        return "<style>\ntd.l, td.z, td.o, td.t, td.f, td.m, td.x, th.h, table.pluralComp {border: 1px solid #666; font-size: 8pt}\ntable.pluralComp {border-collapse:collapse}\nth.h {background-color:#EEE; border-top: 2px solid #000; border-bottom: 2px solid #000;}\ntd.l {background-color:#C0C; border-top: 2px solid #000; color:white; font-weight: bold}\ntd.z {background-color:#F00}\ntd.o {background-color:#DD0}\ntd.t {background-color:#0F0}\ntd.f {background-color:#0DD}\ntd.m {background-color:#99F}\ntd.x {background-color:#CCC}\ntd.c01 {text-decoration:underline}\n";
    }

    public static void writeTables(CLDRFile english, PrintWriter out) {
        for (SupplementalDataInfo.PluralType pluralType : SupplementalDataInfo.PluralType.values()) {
            for (Integral integral : Integral.values()) {
                if (pluralType == SupplementalDataInfo.PluralType.ordinal && integral == Integral.fraction) continue;
                SnapshotInfo info = PluralSnapshot.getInstance(pluralType, integral);
                System.out.println("\n" + String.valueOf((Object)integral) + "\n");
                System.out.println(info.toOverview());
                String title = UCharacter.toTitleCase(pluralType.toString(), null) + "-" + UCharacter.toTitleCase(integral.toString(), null);
                out.println("<h3>" + CldrUtility.getDoubleLinkedText(title) + "</h3>");
                if (integral == Integral.fraction) {
                    out.println("<p><i>This table has not yet been updated to capture the new types of plural fraction behavior.</i></p>");
                }
                out.println("<table class='pluralComp'>");
                int lastCount = -1;
                int lastCount01 = -1;
                out.println(info.toHtmlStringHeader());
                for (Map.Entry<PluralSnapshot, Set<String>> ruleEntry : info) {
                    PluralSnapshot ss = ruleEntry.getKey();
                    Set<String> locales = ruleEntry.getValue();
                    System.out.println();
                    System.out.println(locales);
                    System.out.println(ss);
                    TreeMap<String, String> fullLocales = new TreeMap<String, String>();
                    for (String localeId : locales) {
                        String name = english.nameGetter().getNameFromIdentifier(localeId);
                        fullLocales.put(name, localeId);
                    }
                    out.print("<tr><td rowSpan='2'>" + ss.count + "</td><td class='l' colSpan='121'>");
                    int count = 0;
                    for (Map.Entry entry : fullLocales.entrySet()) {
                        String code = (String)entry.getValue();
                        out.print("<span title='" + code + "'>" + (count == 0 ? "" : ", ") + CldrUtility.getDoubleLinkedText(code + "-comp", (String)entry.getKey()) + "</span>");
                        ++count;
                    }
                    out.println("</td></tr>");
                    out.println(ss.toHtmlString());
                    out.println(info.toHtmlStringHeader());
                }
                out.println("</table>");
            }
        }
    }

    static {
        zeroOne.add(0.0);
        zeroOne.add(1.0);
        nf = NumberFormat.getInstance(ULocale.ENGLISH);
        SINGLETONS = new EnumMap(SupplementalDataInfo.PluralType.class);
        SINGLETONS.put(SupplementalDataInfo.PluralType.cardinal, new EnumMap(Integral.class));
        SINGLETONS.put(SupplementalDataInfo.PluralType.ordinal, new EnumMap(Integral.class));
    }

    public static class SnapshotInfo
    implements Iterable<Map.Entry<PluralSnapshot, Set<String>>> {
        private Relation<PluralSnapshot, String> snapshotToLocales = Relation.of(new TreeMap(), TreeSet.class);
        private BitSet pluralsTransitionAt = new BitSet();
        private Integral integral;

        private SnapshotInfo(SupplementalDataInfo.PluralType pluralType, Integral integral) {
            this.integral = integral;
            SupplementalDataInfo supplementalDataInfo = SupplementalDataInfo.getInstance();
            HashMap<String, PluralSnapshot> rulesToSnapshot = new HashMap<String, PluralSnapshot>();
            for (String locale : supplementalDataInfo.getPluralLocales(pluralType)) {
                SupplementalDataInfo.PluralInfo plurals = supplementalDataInfo.getPlurals(pluralType, locale);
                String rules = plurals.getRules();
                PluralSnapshot snap = (PluralSnapshot)rulesToSnapshot.get(rules);
                if (snap == null) {
                    PluralRules pluralRules = PluralRules.createRules(rules);
                    snap = new PluralSnapshot(pluralRules, integral, this.pluralsTransitionAt);
                    rulesToSnapshot.put(rules, snap);
                }
                this.snapshotToLocales.put(snap, locale);
            }
        }

        @Override
        public Iterator<Map.Entry<PluralSnapshot, Set<String>>> iterator() {
            return this.snapshotToLocales.keyValuesSet().iterator();
        }

        public String toOverview() {
            StringBuilder result = new StringBuilder();
            result.append("Transitions:\t 0");
            int i = this.pluralsTransitionAt.nextSetBit(0);
            while (i >= 0) {
                result.append(",").append(i);
                i = this.pluralsTransitionAt.nextSetBit(i + 1);
            }
            return result.toString();
        }

        public String toHtmlStringHeader() {
            StringBuilder result = new StringBuilder();
            result.append("<tr><th class='h'></th>");
            int next = -2;
            int i = this.pluralsTransitionAt.nextSetBit(0);
            while (i >= 0) {
                int vnext;
                next = this.pluralsTransitionAt.nextSetBit(i + 1);
                result.append("<th class='h'>").append(i);
                if (this.integral == Integral.fraction) {
                    result.append(".x");
                }
                int n = vnext = next == -1 ? 128 : next;
                if (vnext > i + 1) {
                    result.append("-").append(String.valueOf(vnext - 1) + (this.integral == Integral.fraction ? ".x" : ""));
                }
                result.append("</th>");
                i = next;
            }
            result.append("</tr>");
            return result.toString();
        }
    }

    public static enum Integral {
        integer,
        fraction;

    }

    public static enum Plurals {
        zero,
        one,
        two,
        few,
        many,
        other("x");

        final String abb;

        private Plurals(String s2) {
            this.abb = s2;
        }

        private Plurals() {
            this.abb = this.name().substring(0, 1);
        }

        public String abbreviated() {
            return this.abb;
        }
    }
}

