/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.unicode.cldr.icu.dev.test.TestFmwk;

public class ShimmedMain {
    public static final String TEST_ARGS = ".testArgs";
    public static final String DEFAULT_ARGS = "-n -q";
    final String[] args;
    private final Class<? extends TestFmwk.TestGroup> clazz;
    private static final Map<String, String> allProps = new ConcurrentHashMap<String, String>();

    public static String[] getArgs(Class<?> clazz) {
        return ShimmedMain.getArgs(clazz, DEFAULT_ARGS);
    }

    public static String[] getArgs(Class<?> clazz, String defaultArgs) {
        String packageName = clazz.getPackage().getName();
        return ShimmedMain.getArgs(packageName, defaultArgs);
    }

    public static String[] getArgs(String packageName, String defaultArgs) {
        String propKey = packageName + TEST_ARGS;
        String[] s2 = ShimmedMain.getAndSplit(defaultArgs, propKey);
        return s2;
    }

    private static String[] getAndSplit(String defaultArgs, String propKey) {
        String toSplit = allProps.computeIfAbsent(propKey, k -> {
            String v = System.getProperty(k, defaultArgs);
            System.err.println(k + "=" + v);
            return v;
        });
        String[] s2 = toSplit.split(" ");
        return s2;
    }

    public static String[] getArgs(String packageName) {
        return ShimmedMain.getArgs(packageName, DEFAULT_ARGS);
    }

    protected ShimmedMain(Class<? extends TestFmwk.TestGroup> clazz) {
        this.clazz = clazz;
        this.args = ShimmedMain.getArgs(clazz);
    }

    public String[] getArgs() {
        return this.args;
    }

    public int runTests() {
        PrintWriter out = new PrintWriter(System.out);
        try {
            Method m4 = this.clazz.getMethod("main", String[].class, PrintWriter.class);
            int n = (Integer)m4.invoke(null, this.getArgs(), out);
            out.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException nsm) {
                throw new RuntimeException("Could not invoke main for " + String.valueOf(this.clazz), nsm);
            }
        }
    }
}

