/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Relation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SupplementalDataInfo;

public class UExtension {
    static SupplementalDataInfo data = SupplementalDataInfo.getInstance(CLDRPaths.SUPPLEMENTAL_DIRECTORY);
    static Pattern SEP = PatternCache.get("[-_]");
    static Pattern SPACE = PatternCache.get("\\s");
    static Pattern ALPHANUM = PatternCache.get("[0-9A-Za-z]{2,8}");
    static Pattern CODEPOINTS = PatternCache.get("(10|[0-9A-Fa-f])?[0-9A-Fa-f]{4}(\\s(10|[0-9A-Fa-f])?[0-9A-Fa-f]{4})*");
    static Relation<String, String> validKeyTypes = data.getBcp47Keys();
    private boolean validating = false;
    private SortedMap<String, List<String>> keyTypes = new TreeMap<String, List<String>>();
    private Set<String> attributes = new TreeSet<String>();

    public Set<String> getKeys() {
        return this.keyTypes.keySet();
    }

    public List<String> getTypes(String key) {
        return (List)this.keyTypes.get(key);
    }

    public Set<String> getAttributes() {
        return this.attributes;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public UExtension setValidating(boolean validating) {
        this.validating = validating;
        return this;
    }

    public UExtension parse(String source) {
        String key = null;
        List<String> list = null;
        Set<String> validSubtypes = null;
        Matcher alphanum = ALPHANUM.matcher("");
        for (String subtag : SEP.split(source)) {
            if (!alphanum.reset(subtag).matches()) {
                throw new IllegalArgumentException("Invalid subtag contents, must be [0-9 A-Z a-z]{2,8}: " + subtag);
            }
            if ((subtag = subtag.toLowerCase(Locale.ENGLISH)).length() == 2) {
                if (list != null && (list.size() == 0 || !key.equals("vt") && list.size() > 1)) {
                    throw new IllegalArgumentException("Illegal number of subtypes for: " + key + "\t" + String.valueOf(list));
                }
                key = subtag;
                if (this.validating && (validSubtypes = validKeyTypes.getAll(key)) == null) {
                    throw new IllegalArgumentException("Invalid key: " + key);
                }
                list = (List)this.keyTypes.get(key);
                if (list != null) {
                    throw new IllegalArgumentException("Multiple keys with same value: " + subtag);
                }
                list = new ArrayList<String>();
                this.keyTypes.put(key, list);
                continue;
            }
            if (key == null) {
                if (this.validating) {
                    throw new IllegalArgumentException("No attributes currently valid: " + subtag);
                }
                this.attributes.add(subtag);
                break;
            }
            if (this.validating && (key.equals("vt") ? !CODEPOINTS.matcher(subtag).matches() : !validSubtypes.contains(subtag))) {
                throw new IllegalArgumentException("Illegal subtypes: " + key + "-" + subtag);
            }
            list.add(subtag);
        }
        this.attributes = Collections.unmodifiableSet(this.attributes);
        for (String key2 : this.keyTypes.keySet()) {
            list = (List)this.keyTypes.get(key2);
            this.keyTypes.put(key2, Collections.unmodifiableList(list));
        }
        this.keyTypes = Collections.unmodifiableSortedMap(this.keyTypes);
        return this;
    }

    public String toString() {
        return "{attributes=" + String.valueOf(this.attributes) + ", keyTypes=" + String.valueOf(this.keyTypes) + "}";
    }
}

